% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gimme.R
\name{gimmeSEM}
\alias{gimmeSEM}
\alias{gimme}
\title{Group iterative multiple model estimation.}
\usage{
gimmeSEM(data        = "",
         out         = "",
         sep         = "",
         header      = ,
         ar          = TRUE,
         plot        = TRUE,
         subgroup    = FALSE,
         sub_feature = "lag & contemp",
         confirm_subgroup = NULL,
         paths       = NULL,
         exogenous   = NULL,
         conv_vars   = NULL,
         conv_length = 16, 
         conv_interval = 1,
         mult_vars   = NULL,
         mean_center_mult = FALSE,
         standardize = FALSE,
         groupcutoff = .75,
         subcutoff   = .5,
         diagnos     = FALSE, 
         ms_allow         = FALSE,
         ms_tol           = 1e-5,
         lv_model         = NULL, 
         lv_scores        = "regression",       
         lv_estimator     = "miiv",             
         lv_miiv_scaling  = "first.indicator", 
         lv_final_estimator = "miiv")
}
\arguments{
\item{data}{The path to the directory where the data files are located,
or the name of the list containing each individual's time series. Each file
or matrix must contain one matrix for each individual containing a T (time)
by p (number of variables) matrix where the columns represent variables and
the rows represent time. Individuals must have the same variables (p)
but can have different lengths of observations (T).}

\item{out}{The path to the directory where the results will be stored
(optional). If specified,
a copy of output files will be replaced in directory. If directory at
specified path does not exist, it will be created.}

\item{sep}{The spacing of the data files. 
"" indicates space-delimited,
"/t" indicates tab-delimited, "," indicates comma delimited. Only necessary
to specify if reading data in from physical directory.}

\item{header}{Logical. Indicate TRUE for data files with a header. Only
necessary to specify if reading data in from physical directory.}

\item{ar}{Logical. If TRUE, begins search for group model with
autoregressive (AR) paths freed for estimation. If ms_allow=TRUE, it is recommended
to set ar=FALSE.  Multiple solutions are unlikely to be found when ar=TRUE.  Defaults to TRUE.}

\item{plot}{Logical. If TRUE, graphs depicting relations among variables
of interest will automatically be
created. Solid lines represent contemporaneous relations (lag 0) and dashed lines reflect 
lagged relations (lag 1). For individual-level plots, red paths represent positive weights
and blue paths represent negative weights. Width of paths corresponds to estimated path weight.
For the group-level plot, black represents group-level paths, grey represents
individual-level paths, and (if subgroup = TRUE)
green represents subgroup-level paths. For the group-level plot,
the width of the edge corresponds to the count. Defaults to TRUE.}

\item{subgroup}{Logical. If TRUE, subgroups are generated based on
similarities in model features using the \code{walktrap.community}
function from the \code{igraph} package. When ms_allow=TRUE, subgroup
should be set to FALSE.  Defaults to FALSE.}

\item{sub_feature}{Option to indicate feature(s) used to subgroup individuals. Defaults to
"lag & contemp" for lagged and contemporaneous, which is the original method. Can use 
"lagged" or "contemp" to subgroup solely on features related to lagged and contemporaneous 
relations, respectively.}

\item{confirm_subgroup}{Dataframe. Option only available when subgroup = TRUE. Dataframe should contain two columns. The first
column should specify file labels (the name of the data files without file extension), 
and the second should contain integer values (beginning at 1) 
specifying the subgroup membership for each individual.
function from the \code{igraph} package. Defaults to TRUE.}

\item{paths}{\code{lavaan}-style syntax containing paths with which
to begin model estimation (optional). That is, Y~X indicates that Y
is regressed on X, or X predicts Y. If no header is used,
then variables should be referred to with V followed (with no separation)
by the column number. If a
header is used, variables should be referred to using variable names.
To reference lag variables, "lag" should be added to the end of the variable
name with no separation. Defaults to NULL. #### Need to explain mult_vars too. ####}

\item{exogenous}{Vector of variable names to be treated as exogenous (optional).
That is, exogenous variable X can predict Y but cannot be predicted by Y.
If no header is used, then variables should be referred to with V followed
(with no separation) by the column number. If a header is used, variables
should be referred to using variable names. Defaults to NULL.}

\item{conv_vars}{Vector of variable names to be convolved via smoothed Finite Impulse 
Response (sFIR). Note, conv_vars are not not automatically considered exogenous variables.
To treat conv_vars as exogenous use the exogenous argument. Variables listed in conv_vars 
must be binary variables. If there is missing data in the endogenous variables their values 
will be imputed for the convolution operation only. Defaults to NULL. ### If there are multiple 
variables listed in conv_vars they are not used in the convolution of additional conv_vars.## 
You can't do lagged variables.}

\item{conv_length}{Expected response length in seconds. For functional MRI BOLD, 16 seconds (default) is typical
for the hemodynamic response function.}

\item{conv_interval}{Interval between data acquisition. Currently must be a constant. For 
fMRI studies, this is the repetition time. Defaults to 1.}

\item{mult_vars}{Vector of variable names to be multiplied to explore bilinear/modulatory
effects (optional). All multiplied variables will be treated as exogenous (X can predict
Y but cannot be predicted by Y). Within the vector, multiplication of two variables should be
indicated with an asterik (e.g. V1*V2). If no header is used, variables should be referred to with 
V followed by the column number (with no separation). If a header is used, each variable should be
referred to using variable names. If multiplication with the lag 1 of a variable is desired, the 
variable name should be followed by "lag" with no separation (e.g. V1*V2lag).}

\item{mean_center_mult}{Logical. If TRUE, the variables indicated in mult_vars will be mean-centered
before being multiplied together. Defaults to FALSE.}

\item{standardize}{Logical. If TRUE, all variables will be standardized to have a mean of zero and a
standard deviation of one. Defaults to FALSE.}

\item{groupcutoff}{Cutoff value for group-level paths. Defaults to .75,
indicating that a path must be significant across 75\% of individuals to be
included as a group-level path.}

\item{subcutoff}{Cutoff value for subgroup- level paths. Defaults to .5,
indicating that a path must be significant across at least 50\% of the
individuals in a subgroup to be considered a subgroup-level path.}

\item{diagnos}{Logical.If TRUE provides internal output for diagnostic purposes. Defaults to FALSE.}

\item{ms_allow}{Logical. If TRUE provides multiple solutions when more than one path has identical 
modification index values.  When ms_allow=TRUE, it is recommended
to set ar=FALSE.  Multiple solutions are unlikely to be found when ar=TRUE.  Additionally,
subgroup should be set to FALSE.}

\item{ms_tol}{Precision used when evaluating similarity of modification indices when ms_allow = TRUE.  We recommend
that ms_tol not be greater than the default, especially when standardize=TRUE.     
Defaults to 1e-5.}

\item{lv_model}{Invoke latent variable modeling by providing the measurement model syntax here. lavaan
conventions are used for relating observed variables to factors. Defaults to NULL}

\item{lv_scores}{Method used for estimating latent variable scores from parameters obtained from the factor analysis 
when lv_model is not NULL. Options are: "regression" (Default) or bartlett".}

\item{lv_estimator}{Estimator used for factor analysis. Options are "miiv" (default) or "pml" (pseudo-ML).}

\item{lv_miiv_scaling}{Type of scaling indicator to use when "miiv" selected for lv_estimator. Options are
"first.indicator" (Default; the first observed variable in the measurement equation is used), "group" 
(best one for the group), or "individual" (each individual has the best one for them according to R2).}

\item{lv_final_estimator}{Estimator for final estimations. "miiv" (Default) or "pml" (pseudo-ML).}
}
\description{
This function identifies structural equation models for each
individual that consist of both group-level and individual-level paths.
}
\details{
In main output directory:
 \itemize{
 \item{\strong{indivPathEstimates}} {Contains estimate, standard error,
 p-value, and z-value for each path for each individual.
 If subgroup = TRUE and subgroups are found, then a column is present
 containing the subgroup membership for each individual. Also contains the
 level at which each path was estimated: group, subgroup, or individual.}
 \item{\strong{summaryFit}} {Contains model fit information for individual-
 level models. If subgroups are requested, this file also contains the
 subgroup membership for each individual.}
 \item{\strong{summaryPathCountMatrix}} Contains counts of total number of
 paths, both contemporaneous and lagged, estimated for the sample. The row
 variable is the outcome and the column variable is the predictor variable.
 \item{\strong{summaryPathCounts}} {Contains summary count information for
 paths identified at the group-, subgroup (if subgroup = TRUE), and
 individual-level.}
 \item{\strong{summaryPathsPlot}} {Produced if plot = TRUE. Contains figure
 with group, subgroup (if subgroup = TRUE), and individual-level paths
 for the sample. Black paths are group-level, green paths are subgroup-level,
 and grey paths are individual-level, where the thickness of the line
 represents the count.}
 }
 In subgroup output directory (if subgroup = TRUE):
 \itemize{
 \item{\strong{subgroup\emph{k}PathCounts}} Contains counts of relations
 among lagged and contemporaneous variables for the \strong{\emph{k}}th
 subgroup.
 \item{\strong{subgroup\emph{k}Plot}} Contains plot of group, subgroup,
 and individual level paths for the \strong{\emph{k}}th subgroup.
 Black represents group-level paths, grey represents individual-level paths,
 and green represents subgroup-level paths.
 }
 Note: if a subgroup of size n = 1 is discovered, subgroup-level output is
 not produced. \cr
 In individual output directory (where \strong{\emph{id}} represents the
 original file name for each individual):
 \itemize{
 \item{\strong{\emph{id}Betas}} Contains individual-level estimates
  of each path for each individual.
 \item{\strong{\emph{id}StdErrors}} Contains individual-level standard errors
 for each path for each individual.
 \item{\strong{\emph{id}Plot}} Contains individual-level plots. Red paths
 represent positive weights and blue paths represent negative weights.
}
}
\examples{
 \dontrun{
paths <- 'V2 ~ V1
          V3 ~ V4lag'

fit <- gimmeSEM(data     = simData,
                out      = "C:/simData_out",
                subgroup = TRUE, 
                paths    = paths)

print(fit, mean = TRUE)
print(fit, subgroup = 1, mean = TRUE)
print(fit, file = "group_1_1", estimates = TRUE)
print(fit, subgroup = 2, fitMeasures = TRUE)
plot(fit, file = "group_1_1")
 }
}
\references{
Gates, K.M. & Molenaar, P.C.M. (2012). Group search algorithm
recovers effective connectivity maps for individuals
in homogeneous and heterogeneous samples. NeuroImage, 63, 310-319.

Lane, S.T. & Gates, K.M. (2017). Automated selection of robust
individual-level structural equation models for time series data.
Structural Equation Modeling.

Adriene M. Beltz & Peter C. M. Molenaar (2016) Dealing 
with Multiple Solutions in Structural Vector Autoregressive Models, 
Multivariate Behavioral Research, 51:2-3, 357-373.
}
\author{
Stephanie Lane and Zachary Fisher
}
\keyword{gimmeSEM}
