% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrangeFiles.R
\name{rearrangeFiles}
\alias{rearrangeFiles}
\title{Rearrange GIMMS files by date}
\usage{
rearrangeFiles(x = NULL, dsn = getwd(), pattern = "^geo.*.VI3g$",
  pos = c(4, 6, 11), ...)
}
\arguments{
\item{x}{Character. Vector of (local or online) filepaths. If \code{NULL},
\code{dsn} will be searched for available files via pattern matching.}

\item{dsn}{Character. Path to look for GIMMS data. If not supplied and 'x' is
missing, this defaults to the current working directory.}

\item{pattern}{Character. A regular expression passed on to
\code{\link{list.files}}.}

\item{pos}{Integer. The start positions of year, month and period ('a' or
'b') in the target GIMMS files. Unless modified, this usually defaults to
\code{c(4, 6, 11)} (see 'References').}

\item{...}{Further arguments passed on to \code{\link{list.files}}.}
}
\value{
A vector of filepaths arranged in ascending order of time.
}
\description{
Rearrange GIMMS-related files in ascending order of time.
}
\examples{
## latest version of files inventory
gimms_files <- updateInventory(sort = FALSE)
head(gimms_files)

## re-arrange vector with available files according to date
gimms_files_arr <- rearrangeFiles(gimms_files)
head(gimms_files_arr)

}
\author{
Florian Detsch
}
\references{
\url{http://ecocast.arc.nasa.gov/data/pub/gimms/3g.v0/00READMEgeo.txt}
(accessed on January 15, 2016).
}
\seealso{
\code{\link{list.files}}
}

