% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qualityControl.R
\docType{methods}
\name{qualityControl}
\alias{qualityControl}
\alias{qualityControl,RasterStackBrick-method}
\title{Perform Quality Control on GIMMS NDVI3g Data}
\usage{
\S4method{qualityControl}{RasterStackBrick}(x, keep = NULL,
  filename = "", ...)
}
\arguments{
\item{x}{A single 2-layered \code{RasterStack} object (NDVI and flags).}

\item{keep}{\code{integer}. Accepted flag values (see 'Details').}

\item{filename}{\code{character}. Optional output filename.}

\item{...}{Further arguments passed to \code{\link{writeRaster}}.}
}
\value{
A quality-controlled 'RasterLayer' object.
}
\description{
Perform quality control on GIMMS NDVI3g data based on the companion flag
information. This is merely a wrapper around \code{\link{overlay}} and, since
quality control is readily available through \code{\link{rasterizeGimms}}, it
is strongly recommended to use the latter function for this purpose.
}
\details{
If 'keep' is missing, the function will automatically skip quality control
and return the input object.
}
\examples{
\dontrun{
tmp <- tempdir()

## Download NDVI3g.v1 sample data
ecocast <- system.file("extdata", "inventory_ecv1.rds", package = "gimms")
gimms_files <- downloadGimms(readRDS(ecocast)[1], dsn = tmp)

## Import data as 'Raster*' objects
ndvi <- raster::raster(gimms_files, varname = "ndvi")
ndvi[ndvi[] \%in\% c(-32768, -3000)] <- NA
ndvi <- ndvi / 1e4

flag <- floor(raster::raster(gimms_files, varname = "percentile") / 2e3)

## Perform quality control and visualize
to_check <- stack(ndvi[[1]], flag[[1]])
qcl <- qualityControl(to_check, keep = 0)

plot(qcl)
}

## see also 'Examples' section in ?rasterizeGimms for automated quality check

}
\seealso{
\code{\link{rasterizeGimms}}, \code{\link{overlay}}.
}
