% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gips_class.R
\name{gips}
\alias{gips}
\alias{new_gips}
\alias{validate_gips}
\title{The constructor of a \code{gips} class.}
\usage{
gips(
  S,
  number_of_observations,
  delta = 3,
  D_matrix = NULL,
  was_mean_estimated = TRUE,
  perm = ""
)

new_gips(
  list_of_gips_perm,
  S,
  number_of_observations,
  delta,
  D_matrix,
  was_mean_estimated,
  optimization_info
)

validate_gips(g)
}
\arguments{
\item{S}{A matrix; estimated covariance matrix.
When \code{Z} is the observed data:
\itemize{
\item if one does not know the theoretical mean and has to
estimate it with the observed mean, use \code{S = cov(Z)},
and leave parameter \code{was_mean_estimated = TRUE} as default.
\item if one know the theoretical mean is 0, use
\code{S = (t(Z) \%*\% Z) / number_of_observations}, and set
parameter \code{was_mean_estimated = FALSE};
}}

\item{number_of_observations}{A number of data points
that \code{S} is based on.}

\item{delta}{A number, hyper-parameter of a Bayesian model.
Has to be bigger than 2.
See \strong{Hyperparameters} section bellow.}

\item{D_matrix}{A symmetric, positive-definite matrix of the same size as \code{S}.
Hyper-parameter of a Bayesian model.
When \code{NULL}, the identity matrix is taken.
See \strong{Hyperparameters} section bellow.}

\item{was_mean_estimated}{A boolean.
\itemize{
\item Set \code{TRUE} (default) when your \code{S} parameter is a result of
a \code{\link[stats:cor]{stats::cov()}} function.
\item Set FALSE when your \code{S} parameter is a result of
a \code{(t(Z) \%*\% Z) / number_of_observations} calculation.
}}

\item{perm}{An optional permutation to be the base for the \code{gips} object.
Can be of a \code{gips_perm} or a \code{permutation} class, or anything
the function \code{\link[permutations:permutation]{permutations::permutation()}} can handle.}

\item{list_of_gips_perm}{A list with a single element of
a \code{gips_perm} class. The base object for the \code{gips} object.}

\item{optimization_info}{For internal use only. \code{NULL} or the list with
information about the optimization process.}

\item{g}{Object to be checked whether it is proper object of a \code{gips} class.}
}
\value{
\code{gips()} returns an object of
a \code{gips} class after the safety checks.

\code{new_gips()} returns an object of
a \code{gips} class without the safety checks.

\code{validate_gips()} returns its argument unchanged.
If the argument is not a proper element of a \code{gips} class,
it produces an error.
}
\description{
Create a \code{gips} object.
This object will consist of data and all other information needed to find
the most likely invariant permutation. The optimization itself
will not be performed. One must call the \code{\link[=find_MAP]{find_MAP()}}
function to do it. See examples below.
}
\section{Functions}{
\itemize{
\item \code{new_gips()}: Constructor. Only intended for low-level use.

\item \code{validate_gips()}: Validator. Only intended for low-level use.

}}
\section{Methods for a \code{gips} class}{

\itemize{
\item \code{\link[=summary.gips]{summary.gips()}}
\item \code{\link[=plot.gips]{plot.gips()}}
\item \code{\link[=print.gips]{print.gips()}}
}
}

\section{Hyperparameters}{

In the Bayesian model, the prior distribution for
the covariance matrix is a generalized case of
\href{https://en.wikipedia.org/wiki/Wishart_distribution}{Wishart distribution}.

For brief introduction, see \strong{Bayesian model selection}
section in \code{vignette("Theory", package = "gips")} or in its
\href{https://przechoj.github.io/gips/articles/Theory.html}{pkgdown page}).
}

\examples{
require("MASS") # for mvrnorm()

perm_size <- 5
mu <- runif(5, -10, 10) # Assume we don't know the mean
sigma_matrix <- matrix(
  data = c(
    1.0, 0.8, 0.6, 0.6, 0.8,
    0.8, 1.0, 0.8, 0.6, 0.6,
    0.6, 0.8, 1.0, 0.8, 0.6,
    0.6, 0.6, 0.8, 1.0, 0.8,
    0.8, 0.6, 0.6, 0.8, 1.0
  ),
  nrow = perm_size, byrow = TRUE
) # sigma_matrix is a matrix invariant under permutation (1,2,3,4,5)
number_of_observations <- 13
Z <- MASS::mvrnorm(number_of_observations, mu = mu, Sigma = sigma_matrix)
S <- cov(Z) # Assume we have to estimate the mean

g <- gips(S, number_of_observations)

g_map <- find_MAP(g, show_progress_bar = FALSE, optimizer = "brute_force")
g_map

summary(g_map)

if (require("graphics")) {
  plot(g_map, type = "both", logarithmic_x = TRUE)
}
}
\seealso{
\itemize{
\item \code{\link[stats:cor]{stats::cov()}} - The \code{S} parameter is most of the time
an estimated covariance matrix, so a result of the \code{cov()} function.
For more information, see
\href{https://en.wikipedia.org/wiki/Estimation_of_covariance_matrices}{Wikipedia - Estimation of covariance matrices}.
\item \code{\link[=find_MAP]{find_MAP()}} - The function that finds
the Maximum A Posteriori (MAP) Estimator
for a given \code{gips} object.
\item \code{\link[=gips_perm]{gips_perm()}} - The constructor of a \code{gips_perm} class.
The \code{gips_perm} object is used as the base object for
the \code{gips} object. To be more precise, the base object
for \code{gips} is a one-element list of a \code{gips_perm} object.
}
}
