% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{clone}
\alias{clone}
\alias{clone,character,character-method}
\title{Clone a remote repository}
\usage{
clone(url, local_path, bare = FALSE, branch = NULL, credentials = NULL,
  progress = TRUE)

\S4method{clone}{character,character}(url, local_path, bare = FALSE,
  branch = NULL, credentials = NULL, progress = TRUE)
}
\arguments{
\item{url}{The remote repository to clone}

\item{local_path}{Local directory to clone to.}

\item{bare}{Create a bare repository. Default is FALSE.}

\item{branch}{The name of the branch to checkout. Default is NULL
which means to use the remote's default branch.}

\item{credentials}{The credentials for remote repository
access. Default is NULL. To use and query an ssh-agent for the ssh
key credentials, let this parameter be NULL (the default).}

\item{progress}{Show progress. Default is TRUE.}
}
\value{
A S4 \code{\linkS4class{git_repository}} object
}
\description{
Clone a remote repository
}
\examples{
\dontrun{
## Initialize repository
path_repo_1 <- tempfile(pattern="git2r-")
path_repo_2 <- tempfile(pattern="git2r-")
dir.create(path_repo_1)
dir.create(path_repo_2)
repo_1 <- init(path_repo_1)

## Config user and commit a file
config(repo_1, user.name="Alice", user.email="alice@example.org")

## Write to a file and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           file.path(path_repo_1, "example.txt"))
add(repo_1, "example.txt")
commit(repo_1, "First commit message")

## Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
           file.path(path_repo_1, "example.txt"))
add(repo_1, "example.txt")
commit(repo_1, "Second commit message")

## Change file again and commit.
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad",
             "minim veniam, quis nostrud exercitation ullamco laboris nisi ut"),
           file.path(path_repo_1, "example.txt"))
add(repo_1, "example.txt")
commit(repo_1, "Third commit message")

## Clone to second repository
repo_2 <- clone(path_repo_1, path_repo_2)

## List commits in repositories
commits(repo_1)
commits(repo_2)
}
}
\seealso{
\code{\linkS4class{cred_user_pass}},
\code{\linkS4class{cred_ssh_key}}
}
\keyword{methods}

