% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.r
\docType{methods}
\name{coerce-git_tree-list-method}
\alias{coerce-git_tree-list-method}
\title{Coerce entries in a git_tree to a list of entry objects}
\arguments{
\item{from}{The tree \code{object}}
}
\value{
list of entry objects
}
\description{
Coerce entries in a git_tree to a list of entry objects
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
dir.create(file.path(path, "subfolder"))
repo <- init(path)

## Create a user
config(repo, user.name="Alice", user.email="alice@example.org")

## Create three files and commit
writeLines("First file",  file.path(path, "example-1.txt"))
writeLines("Second file", file.path(path, "subfolder/example-2.txt"))
writeLines("Third file",  file.path(path, "example-3.txt"))
add(repo, c("example-1.txt", "subfolder/example-2.txt", "example-3.txt"))
new_commit <- commit(repo, "Commit message")

## Inspect size of each blob in tree
invisible(lapply(as(tree(new_commit), "list"),
  function(obj) {
    if (is_blob(obj))
      summary(obj)
    NULL
  }))
}
}
\keyword{methods}

