% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.r
\docType{methods}
\name{workdir}
\alias{workdir}
\alias{workdir,git_repository-method}
\alias{workdir,missing-method}
\title{Workdir of repository}
\usage{
workdir(repo)

\S4method{workdir}{missing}()

\S4method{workdir}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository \code{object}
\code{\linkS4class{git_repository}}. If the \code{repo} argument
is missing, the repository is searched for with
\code{\link{discover_repository}} in the current working
directory.}
}
\value{
Character vector with the path of the workdir. If the
repository is bare, \code{NULL} will be returned.
}
\description{
Workdir of repository
}
\examples{
\dontrun{
## Create a directory in tempdir
path <- tempfile(pattern="git2r-")
dir.create(path)

## Initialize a repository
repo <- init(path)

## Get the path of the workdir for repository
workdir(repo)
}
}
\keyword{methods}

