% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/odb.r
\docType{methods}
\name{odb_blobs}
\alias{odb_blobs}
\alias{odb_blobs,git_repository-method}
\title{Blobs in the object database}
\usage{
odb_blobs(repo)

\S4method{odb_blobs}{git_repository}(repo)
}
\arguments{
\item{repo}{The repository}
}
\value{
A data.frame with the following columns:
\describe{
  \item{sha}{The sha of the blob}
  \item{path}{The path to the blob from the tree and sub-trees}
  \item{name}{The name of the blob from the tree that contains the blob}
  \item{len}{The length of the blob}
  \item{commit}{The sha of the commit}
  \item{author}{The author of the commit}
  \item{when}{The timestamp of the author signature in the commit}
}
}
\description{
List all blobs reachable from the commits in the object
database. For each commit, list blob's in the commit tree and
sub-trees.
}
\note{
A blob sha can have several entries
}
\examples{
\dontrun{
## Create a directory in tempdir
path <- tempfile(pattern="git2r-")
dir.create(path)

## Initialize a repository
repo <- init(path)
config(repo, user.name="Alice", user.email="alice@example.org")

## Create a file, add and commit
writeLines("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
           con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit(repo, "Commit message 1")

## Change file and commit
writeLines(c("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do",
             "eiusmod tempor incididunt ut labore et dolore magna aliqua."),
             con = file.path(path, "test.txt"))
add(repo, "test.txt")
commit(repo, "Commit message 2")

## Commit same content under different name in a sub-directory
dir.create(file.path(path, "sub-directory"))
file.copy(file.path(path, "test.txt"), file.path(path, "sub-directory", "copy.txt"))
add(repo, "sub-directory/copy.txt")
commit(repo, "Commit message 3")

## List blobs
odb_blobs(repo)
}
}
\keyword{methods}

