% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_vc.R
\name{write_vc}
\alias{write_vc}
\alias{write_vc.character}
\alias{write_vc.git_repository}
\title{Store a Data.Frame as a Git2rdata Object on Disk}
\usage{
write_vc(
  x,
  file,
  root = ".",
  sorting,
  strict = TRUE,
  optimize = TRUE,
  na = "NA",
  ...,
  split_by
)

\method{write_vc}{character}(
  x,
  file,
  root = ".",
  sorting,
  strict = TRUE,
  optimize = TRUE,
  na = "NA",
  ...,
  split_by = character(0)
)

\method{write_vc}{git_repository}(
  x,
  file,
  root,
  sorting,
  strict = TRUE,
  optimize = TRUE,
  na = "NA",
  ...,
  stage = FALSE,
  force = FALSE
)
}
\arguments{
\item{x}{the \code{data.frame}.}

\item{file}{the name of the git2rdata object. Git2rdata objects cannot
have dots in their name. The name may include a relative path. \code{file} is a
path relative to the \code{root}.
Note that \code{file} must point to a location within \code{root}.}

\item{root}{The root of a project. Can be a file path or a \code{git-repository}.
Defaults to the current working directory (\code{"."}).}

\item{sorting}{an optional vector of column names defining which columns to
use for sorting \code{x} and in what order to use them.
The default empty \code{sorting} yields a warning.
Add \code{sorting} to avoid this warning.
Strongly recommended in combination with version control.
See \code{vignette("efficiency", package = "git2rdata")} for an illustration of
the importance of sorting.}

\item{strict}{What to do when the metadata changes. \code{strict = FALSE}
overwrites the data and the metadata with a warning listing the changes,
\code{strict = TRUE} returns an error and leaves the data and metadata as is.
Defaults to \code{TRUE}.}

\item{optimize}{If \code{TRUE}, recode the data to get smaller text files.
If \code{FALSE}, \code{meta()} converts the data to character.
Defaults to \code{TRUE}.}

\item{na}{the string to use for missing values in the data.}

\item{...}{parameters used in some methods}

\item{split_by}{An optional vector of variables name to split the text files.
This creates a separate file for every combination.
We prepend these variables to the vector of \code{sorting} variables.}

\item{stage}{Logical value indicating whether to stage the changes after
writing the data. Defaults to \code{FALSE}.}

\item{force}{Add ignored files. Default is FALSE.}
}
\value{
a named vector with the file paths relative to \code{root}. The names
contain the hashes of the files.
}
\description{
A git2rdata object consists of two files.
The \code{".tsv"} file contains the raw data as a plain text tab separated file.
The \code{".yml"} contains the metadata on the columns in plain text YAML format.
See \code{vignette("plain text", package = "git2rdata")} for more details on the
implementation.
}
\note{
\code{..generic} is a reserved name for the metadata and is a forbidden
column name in a \code{data.frame}.
}
\examples{
## on file system

# create a directory
root <- tempfile("git2rdata-")
dir.create(root)

# write a dataframe to the directory
write_vc(iris[1:6, ], file = "iris", root = root, sorting = "Sepal.Length")
# check that a data file (.tsv) and a metadata file (.yml) exist.
list.files(root, recursive = TRUE)
# read the git2rdata object from the directory
read_vc("iris", root)

# store a new version with different observations but the same metadata
write_vc(iris[1:5, ], "iris", root)
list.files(root, recursive = TRUE)
# Removing a column requires version requires new metadata.
# Add strict = FALSE to override the existing metadata.
write_vc(
  iris[1:6, -2], "iris", root, sorting = "Sepal.Length", strict = FALSE
)
list.files(root, recursive = TRUE)
# storing the orignal version again requires another update of the metadata
write_vc(iris[1:6, ], "iris", root, sorting = "Sepal.Width", strict = FALSE)
list.files(root, recursive = TRUE)
# optimize = FALSE stores the data more verbose. This requires larger files.
write_vc(
  iris[1:6, ], "iris2", root, sorting = "Sepal.Width", optimize = FALSE
)
list.files(root, recursive = TRUE)



## on git repo using a git2r::git-repository

# initialise a git repo using the git2r package
repo_path <- tempfile("git2rdata-repo-")
dir.create(repo_path)
repo <- git2r::init(repo_path)
git2r::config(repo, user.name = "Alice", user.email = "alice@example.org")

# store a dataframe in git repo.
write_vc(iris[1:6, ], file = "iris", root = repo, sorting = "Sepal.Length")
# This git2rdata object is not staged by default.
status(repo)
# read a dataframe from a git repo
read_vc("iris", repo)

# store a new version in the git repo and stage it in one go
write_vc(iris[1:5, ], "iris", repo, stage = TRUE)
status(repo)

# store a verbose version in a different gir2data object
write_vc(
  iris[1:6, ], "iris2", repo, sorting = "Sepal.Width", optimize = FALSE
)
status(repo)
}
\seealso{
Other storage: 
\code{\link{display_metadata}()},
\code{\link{list_data}()},
\code{\link{prune_meta}()},
\code{\link{read_vc}()},
\code{\link{relabel}()},
\code{\link{rename_variable}()},
\code{\link{rm_data}()},
\code{\link{update_metadata}()},
\code{\link{verify_vc}()}
}
\concept{storage}
