% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comments.R
\name{gl_get_comments}
\alias{gl_get_comments}
\alias{gl_get_issue_comments}
\alias{gl_get_commit_comments}
\alias{gl_comment_commit}
\alias{gl_comment_issue}
\alias{gl_edit_comment}
\alias{gl_edit_issue_comment}
\alias{gl_edit_commit_comment}
\title{Get the comments/notes of a commit or issue}
\usage{
gl_get_comments(object_type = "issue", id, note_id = c(), project, ...)

gl_get_issue_comments(...)

gl_get_commit_comments(...)

gl_comment_commit(project, id, text, ...)

gl_comment_issue(project, id, text, ...)

gl_edit_comment(object_type, text, ...)

gl_edit_issue_comment(...)

gl_edit_commit_comment(...)
}
\arguments{
\item{object_type}{one of "issue" or "commit". Snippets and merge_requests are not implemented yet.}

\item{id}{id of object: sha for commits, not issues notes/comments:
(project-wide) id for api version 4, (global) iid for api version 3}

\item{note_id}{id of note}

\item{project}{project name or id}

\item{...}{passed on to \code{\link{gitlab}} API call. See Details.}

\item{text}{Text of comment/note to add or edit (translates to gitlab API note/body respectively)}
}
\description{
Get the comments/notes of a commit or issue
}
\details{
For \code{gl_comment_commit} ... might also contain \code{path}, \code{line}
and \code{line_type} (old or new) to attach the comment to a specific in a file.
See http://doc.gitlab.com/ce/api/commits.html
}
\examples{
\dontrun{
my_project <- gl_project_connection(project = "testor"...) ## fill in login parameters
my_project(gl_get_comments, "issue", 1)
my_project(gl_get_comments, "commit", "8ce5ef240123cd78c1537991e5de8d8323666b15")
my_project(gl_comment_issue, 1, text = "Almost done!")
}
}
