% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_env.R
\name{set_gitlab_connection}
\alias{set_gitlab_connection}
\alias{unset_gitlab_connection}
\title{Get/set a gitlab connection for all calls}
\usage{
set_gitlab_connection(gitlab_con = NULL, ...)

unset_gitlab_connection()
}
\arguments{
\item{gitlab_con}{A function used for gitlab API calls, such
as \code{\link{gitlab}} or as returned by \code{\link{gl_connection}}.}

\item{...}{if gitlab_con is NULL, a new connection is created used the parameters
is ... using \code{\link{gl_connection}}}
}
\description{
This sets the default value of \code{gitlab_con} 
in a call to \code{\link{gitlab}}
}
\examples{
\dontrun{
set_gitlab_connection("http://gitlab.example.com", private_token = "123####89")
}
}
