% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.glca.R
\name{coef.glca}
\alias{coef.glca}
\title{Extracts \code{glca} Model Coefficients}
\usage{
\method{coef}{glca}(object, digits = max(3, getOption("digits") - 3),
  show.signif.stars = getOption("show.signif.stars"), ...)
}
\arguments{
\item{object}{an object of "\code{glca}"}

\item{digits}{number of significant digits to use when printing}

\item{show.signif.stars}{logical. If TRUE, ‘significance stars’ are printed for each coefficient}

\item{...}{further arguments passed to or from other methods}
}
\value{
Coefficient matrix from the \code{glca} model

If the model has calculated standard errors, coefficient matrix contains standard errors, t-statistic, and its p-value.
}
\description{
Extracts regression coefficients of \code{glca} model if the model includes covariates.
}
\examples{
## For examples see example(glca)

}
\seealso{
\code{\link{glca}}
}
