% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMunich2019dataset.R
\name{plotMunich2019dataset}
\alias{plotMunich2019dataset}
\title{Plot variables from the munich2019dataset}
\usage{
plotMunich2019dataset(name1, name2 = NA, savePath = NA)
}
\arguments{
\item{name1}{Character. The name of the first variable to plot.}

\item{name2}{Character (optional). The name of the second variable for bivariate plots. Default is NA.}

\item{savePath}{Character (optional). File path where the plot should be saved.
Default is NULL which means no plot will be saved.
To save a plot using all the default options put an empty string.
The format must be: 'filepath/filename.extension' where:
\itemize{
\item filepath is the directory (must already exist), default is the working directory;
\item filename is the name of the file, default to 'plot_munich2019dataset_var1_var2_timestamp.png';
\item extension must be one of the supported 'ggsave' extensions and must be specified, unless using the default file name.
}}
}
\value{
A 'ggplot2' object representing the generated plot.
If the specified variables are not found in the dataset, returns a warning.
}
\description{
This function creates a plot of one or two variables from the 'munich2019dataset' dataframe.
It automatically chooses the appropriate plot type based on the variable types.
It can export and save the plot by specifying the directory, filename and extension.
Provided variable names need to be in the dataset, otherwise an error will be launched.
The function makes it easy to plot univariate and bivariate plots while offering a quick way to save and export them.
}
\details{
The function supports the following plotting logic:
\itemize{
\item If only 'name1' is provided:
\itemize{
\item Numeric/integer variable → Histogram.
\item Character/factor variable → Bar plot.
}
\item If both 'name1' and 'name2' are provided:
\itemize{
\item One numeric/integer and one categorical → Boxplot.
\item Both categorical → Grouped bar plot.
}
}
}
\examples{
# Univariate plot without saving
plotMunich2019dataset("age_years")

# Bivariate plot without saving
plotMunich2019dataset("cHsp70_low0_high1", "sex_male0_female1")

\donttest{
# Bivariate plot saved in the path directory with the chosen name and extension
plotMunich2019dataset("age_years", "sex_male0_female1", savePath = NA)

# Univariate plot saved in the working directory with the chosen name and extension
plotMunich2019dataset("sex_male0_female1", savePath = NA)

# Univariate plot saved in the path directory with default name and extension
plotMunich2019dataset("MGMTmethylation_methylated1_unmethylated0", savePath = NA)
}

}
\seealso{
\code{\link[DataExplorer:plot_bar]{DataExplorer::plot_bar()}}, \code{\link[DataExplorer:plot_histogram]{DataExplorer::plot_histogram()}}, \link[DataExplorer:plot_boxplot]{DataExplorer::plot_boxplot}, \code{\link[=savePlot]{savePlot()}}
}
