% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.gllvm.R
\name{vcov.gllvm}
\alias{vcov.gllvm}
\alias{vcov}
\title{Returns variance-covariance matrix of coefficients in a GLLVM.}
\usage{
\method{vcov}{gllvm}(object)
}
\arguments{
\item{object}{an object of class 'gllvm'.}
}
\description{
Returns the variance-covariance matrix of the parameters from a GLLVM. If the variance-covariance matrix was not calculated after model fitting, this function will have to calculate the variance-covariance matrix, which may be computational intensive for a large number of species and/or sites.
}
\details{
Calculates the variance-covariance matrix of a GLLVM object using \code{\link{se.gllvm}}, which may be computational intensive with many parameters.The parameters might have unintuitive names. Fixed-effects coefficients are labled "b", and are ordered per species as: 1) intercepts 2) fixed-effects slopes. Coefficients of the latent variables are labled "lambda" (linear coefficients) or "lambda2".
}
\author{
Bert van der Veen
}
