% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{confint_contrast}
\alias{confint_contrast}
\alias{confint_contrast.default}
\title{Confidence interval estimation of contrasts}
\usage{
confint_contrast(
  model,
  contrast,
  method = NULL,
  level = 0.95,
  alternative = c("two.sided", "less", "greater"),
  ...
)

\method{confint_contrast}{default}(
  model,
  contrast,
  method = NULL,
  level = 0.95,
  alternative = c("two.sided", "less", "greater"),
  clevel_logit_tol = 1e-05,
  deriv_rel_SE = 1e-04,
  ...,
  force = FALSE,
  debuglevel = 1
)
}
\arguments{
\item{model}{a fitted statistical model such as a glm or a coxph.}

\item{contrast}{numeric vector of the same length as the number of coefficients in the model; it describes the contrast \code{sum(contrast*fixcoef(model))}.}

\item{method}{character string value; specification of the algorithm used (implementation dependent). NULL must be accepted.
Suggested values are "LRT" for inverted likelihood ratio test, "Rao" for inverted Rao's score test, "Wald" for inverted Wald's test.}

\item{level}{numeric value between 0 and 1; nominal confidence level.}

\item{alternative}{character value; either "two.sided", "less" or "greater", specifying a two-sided or one-sided confidence interval.}

\item{...}{Additional parameters that may be used by some implementations.}

\item{clevel_logit_tol}{numeric value; the difference of logit(1-level) that can be tolerated for convergence of the algorithm.}

\item{deriv_rel_SE}{numeric value; the delta for the numeric derivative, used for the Newton-Raphson algorithm applied to the logit(1-pvalue).
It is expressed as a multiplicative factor for the Standard Error of the contrast.}

\item{force}{logical; if TRUE, force computation of P-values in case of convergence problems.}

\item{debuglevel}{integer value; set to 0 (default) to disable warnings, 1 to enable warnings and 2 to enable warnings and notes.}
}
\value{
A vector of length 2. The first value MUST be named "lower" and be the lower bound of the confidence interval.
The second value MUST be named "upper" and be the upper bound of the confidence interval.
}
\description{
This S3 generic function allows the computation of confidence intervals of contrasts
(i.e. linear combinations) of fixed-effects in many models.
The default implementation computes Wald's confidence intervals with any model as long as it consistently implements \code{\link{fixcoef}}, \code{\link{vcov_fixcoef}} and \code{\link{df_for_wald}}.
It is also specialized for GLMs with Wald's, LRT and Rao's confidence intervals and may be specialized with other models.
}
\details{
This function should consistent with \code{\link{estimate_contrast}} and \code{\link{p_value_contrast}} as they are designed to be used together.
If a null hypothesis (H0) is specified, it MUST be ignored by \code{confint_contrast} as in \code{estimate_contrast}.
If you want to make it consistent with \code{p_value_contrast} you may subtract H0 from the output of \code{estimate_contrast} and \code{confint_contrast}.

When alternative is "less" or  "greater", one-sided confidence intervals are generated.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default implementation
Supports Wald's test on a wide range of models, including \code{\link[stats:lm]{lm}}, \code{\link[stats:lm]{mlm}},
\code{\link[stats:glm]{stats::glm}}, \code{\link[MASS:glm.nb]{negbin}}, \code{\link[MASS:polr]{MASS::polr}},
\code{\link[MASS:rlm]{MASS::rlm}} (with normality assumptions, defeating the purpose of rlm), \code{\link[nlme:lme]{nlme::lme}}, 
\code{\link[nlme:gls]{nlme::gls}}, \code{\link[lme4:lmer]{lme4::lmer}}, \code{\link[lme4:glmer]{lme4::glmer}}, 
\code{\link[mgcv:gam]{mgcv::gam}}, \code{\link[gam:gam]{gam::gam}}, \code{\link[survival:coxph]{survival::coxph}}, 
\code{\link[survival:survreg]{survival::survreg}}, 
\code{\link[nnet:multinom]{nnet::multinom}}, \code{\link[stats:nls]{stats::nls}}.

It can be easily extended by implementing three generic functions:
\code{\link[glmglrt:fixcoef]{fixcoef}}, \code{\link[glmglrt:vcov_fixcoef]{vcov_fixcoef}} and \code{\link[glmglrt:df_for_wald]{df_for_wald}}.
If the implementations of \code{\link[stats:coef]{coef}}, \code{\link[stats:vcov]{vcov}} and \code{\link[stats:df.residual]{df.residual}} are consistent,
you do not have to implement \code{fixcoef}, \code{vcov_fixcoef} and \code{df_for_wald}.

It also provides \code{method="LRT"} and \code{method="Rao"} on \code{\link[stats:glm]{stats::glm}} and \code{method="LRT"} on
negative binomials (\code{\link[MASS:glm.nb]{negbin}}) models.
It is implemented by inverting tests performed by \code{\link{p_value_contrast}}, with the help of the Newton-Raphson algorithm
on the logit of the two-sided P-value.
}}

\examples{
data(mtcars)
model1 = glm(family="gaussian", data=mtcars, hp ~ 0+factor(gear))
# do cars with 5 gears have more horse power (hp) than cars with 4 gears ?
confint_contrast(model1, c(0,-1,1))

# now, we fit an equivalent model (same distribution and same predictions)
model2 = glm(family=gaussian(log), data=mtcars, hp ~ 0+factor(gear))

# do cars with 5 gears have at least twice the horse power than cars with 4 gears ?

confint_contrast(model2, c(0,-1,0.5))

}
\seealso{
Other Contrast functions: 
\code{\link{estimate_confint_contrast}()},
\code{\link{estimate_contrast}()},
\code{\link{p_value_contrast}()}
}
\concept{Contrast functions}
