% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{p_value.glm}
\alias{p_value.glm}
\title{Computing p-values of hypothesis tests on coefficients of Generalized Linear Models and other}
\usage{
\method{p_value}{glm}(
  model,
  method = NULL,
  parm = NULL,
  alternative = c("two.sided", "less", "greater"),
  H0 = 0,
  debuglevel = 1,
  force = FALSE,
  ...
)
}
\arguments{
\item{model}{glm object; as obtained by calling \code{\link[stats:glm]{stats::glm}} or \code{\link[MASS:glm.nb]{MASS::glm.nb}}.}

\item{method}{character value; may either be "LRT" (synonym "Chisq"), "Rao", "wald" (default value, synonym "Wald" and "F").}

\item{parm}{integer or character vector or NULL; specify coefficients to test, by name or indexes.
the default parm=NULL outputs all coefficients.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "two.sided" (default), "greater" or "less". You can specify just the initial letter.}

\item{H0}{numeric vector of length 1 or of the same length as parm; the value of the coefficient under the null hypothesis. Zero by default.}

\item{debuglevel}{integer value; set to 0 (default) to disable warnings, 1 to enable warnings and 2 to enable warnings and notes.}

\item{force}{logical; if TRUE, force computation of P-values in case of convergence problems.}

\item{...}{Ignored arguments. Allows compatibility with the generic \code{\link[parameters:p_value]{parameters::p_value}}.}
}
\value{
a data.frame with two columns; the first column, Parameter represents the name of the coefficient
and p (second column) represents the P-value of the hypothesis test against H0
}
\description{
This S3 method is a specialization of \code{\link[parameters:p_value]{parameters::p_value}}
for \code{\link[stats:glm]{stats::glm}} models.
By default, it computes Wald's P-values that are known to be more biased than LRT P-values,
but the behavior can be overriden by the method="LRT" argument.
This is for compatibility with the default method of \code{\link[parameters:p_value]{parameters::p_value}}.
}
\examples{
require("parameters")
mod = glm(family="poisson", c(2,30) ~ c(0,1), offset=log(c(8,30)))
# Wald's tests (biased)
p_value(mod)
# Rao score tests (biased)
p_value(mod, method="Rao")
# LRT tests (less biased)
p_value(mod, method="LRT")

# only test slope (faster since only one test is performed)
p_value(mod, method="LRT", parm=2)
# is slope greater than log(2) ?
p_value(mod, method="LRT", parm=2, H0=log(2), alternative="greater")
}
