% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_tune.R
\name{select_tune}
\alias{select_tune}
\title{Fit a Sequence of Penalized Generalized Mixed Model via Monte Carlo Expectation Conditional 
Minimization (MCECM) 

\code{select_tune} is used to fit a sequence of penalized generalized mixed models 
via Monte Carlo Expectation Conditional Minimization (MCECM) for 
multiple tuning parameter combinations and is called within
\code{glmmPen} (cannot be called directly by user)}
\usage{
select_tune(
  dat,
  offset = NULL,
  family,
  covar = c("unstructured", "independent"),
  group_X = 0:(ncol(dat$X) - 1),
  penalty,
  lambda0_seq,
  lambda1_seq,
  alpha = 1,
  gamma_penalty = switch(penalty[1], SCAD = 4, 3),
  trace = 0,
  u_init = NULL,
  coef_old = NULL,
  adapt_RW_options = adaptControl(),
  optim_options = optimControl(),
  BIC_option = c("BICq", "BICh", "BIC", "BICNgrp"),
  BICq_calc = TRUE,
  logLik_calc = switch(BIC_option[1], BICq = FALSE, TRUE),
  BICq_posterior = NULL,
  checks_complete = FALSE,
  pre_screen = TRUE,
  ranef_keep = NULL,
  lambda.min.full,
  stage1 = FALSE,
  progress = TRUE
)
}
\arguments{
\item{dat}{a list object specifying y (response vector), X (model matrix of all covariates), 
Z (model matrix for the random effects), and group (numeric factor vector whose value indicates 
the study, batch, or other group identity to which on observation belongs)}

\item{offset}{This can be used to specify an \emph{a priori} known component to be included in the 
linear predictor during fitting. Default set to \code{NULL} (no offset). If the data 
argument is \code{NULL}, this should be a numeric vector of length equal to the 
number of cases (the response). If the data argument specifies a data.frame, the offset
argument should specify the name of a column in the data.frame.}

\item{family}{a description of the error distribution and link function to be used in the model. 
Currently, the \code{glmmPen} algorithm allows the binomial, gaussian, and poisson families
with canonical links only.}

\item{covar}{character string specifying whether the covariance matrix should be unstructured
("unstructured") or diagonal with no covariances between variables ("independent").
Default is set to \code{NULL}. If \code{covar} is set to \code{NULL} and the number of random effects
predictors (not including the intercept) is 
greater than or equal to 10 (i.e. high dimensional), then the algorithm automatically assumes an 
independent covariance structure and \code{covar} is set to "independent". Otherwise if \code{covar}
is set to \code{NULL} and the number of random effects predictors is less than 10, then the
algorithm automatically assumes an unstructured covariance structure and \code{covar} is set to "unstructured".}

\item{group_X}{vector describing the grouping of the covariates in the model matrix.}

\item{penalty}{character describing the type of penalty to use in the variable selection procedure.
Options include 'MCP', 'SCAD', and 'lasso'. Default is MCP penalty. If the random effect covariance
matrix is "unstructured", then a group MCP, group SCAD, or group Lasso penalty is used on the 
random effects coefficients.}

\item{lambda0_seq}{a sequence of non-negative numeric penalty parameters for the fixed 
and random effect parameters, respectively. If \code{NULL}, then a sequence will be automatically 
calculated. See 'Details' section for more details on these default calculations.}

\item{lambda1_seq}{a sequence of non-negative numeric penalty parameters for the fixed 
and random effect parameters, respectively. If \code{NULL}, then a sequence will be automatically 
calculated. See 'Details' section for more details on these default calculations.}

\item{alpha}{Tuning parameter for the Mnet estimator which controls the relative contributions 
from the MCP/SCAD/lasso penalty and the ridge, or L2, penalty. \code{alpha=1} is equivalent to 
the MCP/SCAD/lasso penalty, while \code{alpha=0} is equivalent to ridge regression. However,
\code{alpha=0} is not supported; \code{alpha} may be arbitrarily small, but not exactly zero}

\item{gamma_penalty}{The tuning parameter of the MCP and SCAD penalties. Not used by Lasso penalty.
Default is 4.0 for SCAD and 3.0 for MCP.}

\item{trace}{an integer specifying print output to include as function runs. Default value is 0. 
See Details for more information about output provided when trace = 0, 1, or 2.}

\item{u_init}{matrix giving values to initialize samples from the posterior. If 
Binomial or Poisson families, only need a single row to initialize samples from
the posterior; if Gaussian family, multiple rows needed to initialize the estimate
of the residual error (needed for the E-step). Columns correspond to the 
columns of the Z random effect model matrix.}

\item{coef_old}{vector giving values to initialized the coefficients (both fixed
and random effects)}

\item{adapt_RW_options}{a list of class "adaptControl" from function \code{\link{adaptControl}} 
containing the control parameters for the adaptive random walk Metropolis-within-Gibbs procedure. 
Ignored if \code{\link{optimControl}} parameter \code{sampler} is set to "stan" (default) or "independence".}

\item{optim_options}{a structure of class "optimControl" created 
from function \code{\link{optimControl}} that specifies optimization parameters. See the 
documentation for \code{\link{optimControl}} for more details on defaults.}

\item{BIC_option}{character string specifying the selection criteria used to select the 'best' model.
Default "BICq" option specifies the BIC-ICQ criterion (Ibrahim et al (2011)
<doi:10.1111/j.1541-0420.2010.01463.x>),
which requires a fit of 
a full model; a small penalty (the minimum of the penalty sequence) 
is used for the fixed and random effects. 
The "BICh" option utilizes the hybrid BIC value described in 
Delattre, Lavielle, and Poursat (2014) <doi:10.1214/14-EJS890>.
The regular "BIC" option penalty term uses (total non-zero coefficients)*(length(y) = total number
observations). The "BICNgrp" option penalty term uses (total non-zero coefficients)*(nlevels(group) = number
groups).}

\item{BICq_calc}{logical value indicating if the BIC-ICQ criterion should be used to select the
best model.}

\item{logLik_calc}{logical value specifying if the log likelihood (and log-likelihood based 
calculations BIC, BICh, and BICNgrp) should be calculated for all of the models in the selection procedure. 
If BIC-ICQ is used for selection, the log-likelihood is not needed for each model. 
However, if users are interested
in comparing the best models from BIC-ICQ and other BIC-type selection criteria, setting
\code{logLik_calc} to \code{TRUE} will calculate these other quantities for all of the models.}

\item{BICq_posterior}{an optional character string expressing the path and file basename of a file combination that 
will file-back or currently file-backs a \code{big.matrix} of the posterior draws from the full model.
These full model posterior draws will be used in BIC-ICQ calculations if these calculations
are requested (BIC-ICQ reference: Ibrahim et al (2011)
<doi:https://doi.org/10.1111/j.1541-0420.2010.01463.x>). 
If this argument is
specified as \code{NULL} (default) and BIC-ICQ calculations are requested, the posterior draws
will be saved in the file combination 'BICq_Posterior_Draws.bin' and 'BICq_Posterior_Draws.desc'
in the working directory.
See 'Details' section for additional details about the required format of \code{BICq_posterior}
and the file-backed big matrix.}

\item{checks_complete}{logical value indicating if several data checks have been completed.}

\item{pre_screen}{logical value indicating whether pre-screening should be performed before
model selection (default \code{TRUE}). If the number of random effects considered less than 5,
no pre-screening will be performed. Pre-screening removes random effects from consideration
during the model selection process, which can significantly speed up the algorithm.}

\item{ranef_keep}{vector of 0s and 1s indicating which random effects should 
be considered as non-zero at the start of the algorithm. For each random effect,
1 indicates the random effect should be considered non-zero at start of algorithm,
0 indicates otherwise. The first element for the random intercept should always be 1.}

\item{lambda.min.full}{a vector of two numeric values that gives the fixed and random effect penalty 
values to use in pre-screening and/or the full model fit for the BIC-ICQ calculation 
(if applicable)}

\item{stage1}{logical value indicating if the first stage of the abbreviated two-stage grid
search in the model selection procedure is being performed. \code{FALSE} if either 
performing the second stage of the abbreviated two-stage grid search or if performing the
full grid search over all possible penalty parameter combinations.}

\item{progress}{a logical value indicating if additional output should be given showing the
progress of the fit procedure. If \code{TRUE}, such output includes iteration-level information
for the fit procedure (iteration number EM_iter,
number of MCMC draws nMC, average Euclidean distance between current coefficients and coefficients
from t--defined in \code{\link{optimControl}}--iterations back EM_conv, 
and number of non-zero fixed and random effects
including the intercept). Additionally, \code{progress = TRUE}
gives some other information regarding the progress of the variable selection 
procedure, including the model selection criteria and log-likelihood estimates
for each model fit.
Default is \code{TRUE}.}
}
\value{
A list with the following elements:
\item{results}{matrix of summary results for each lambda tuning parameter combination, used
to select the 'best' model}
\item{out}{list of \code{\link{fit_dat}} results for the best model}
\item{coef}{matrix of coefficient results for each lambda tuning parameter combination. 
Rows correspond with the rows of the results matrix.}
}
\description{
Fit a Sequence of Penalized Generalized Mixed Model via Monte Carlo Expectation Conditional 
Minimization (MCECM) 

\code{select_tune} is used to fit a sequence of penalized generalized mixed models 
via Monte Carlo Expectation Conditional Minimization (MCECM) for 
multiple tuning parameter combinations and is called within
\code{glmmPen} (cannot be called directly by user)
}
