% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxph_utility.R
\name{survival_data}
\alias{survival_data}
\title{Convert Input Survival Data Into Long-Form Data Needed for Fitting a Piecewise
Exponential Model}
\usage{
survival_data(y, X, Z, group, offset_fit = NULL, survival_options)
}
\arguments{
\item{y}{response, which must be a \code{Surv} object (see
\code{\link[survival]{Surv}} from the \code{survival} package)}

\item{X}{matrix of fixed effects covariates}

\item{Z}{matrix of random effects covariates}

\item{group}{vector specifying the group assignment for each subject}

\item{offset_fit}{vector specifying the offset. 
This can be used to specify an \emph{a priori} known component to be included in the 
linear predictor during fitting. Default set to \code{NULL} (no offset). If the data 
argument is not \code{NULL}, this should be a numeric vector of length equal to the 
number of cases (the length of the response vector).}

\item{survival_options}{a structure of class "survivalControl" created 
from function \code{\link{survivalControl}} that specifies several parameters needed to 
properly fit the input survival data using a piecewise constant hazard mixed model. See the 
documentation for \code{\link{survivalControl}} for more details on defaults.}
}
\description{
Converts the input survival data with one row or element corresponding to a 
single observation or subject into a long-form dataset where one observation or subject
contributes \code{j} rows, where \code{j} is the number of time intervals that 
a subject survived at least part-way through.
}
