% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_model.R
\name{bootstrap_model}
\alias{bootstrap_model}
\alias{BootGlmm}
\title{computes bootstrap resamples of your data,
stores estimates + SEs.}
\usage{
bootstrap_model(base_model, base_data, resamples = 9999,
  return_coefs_instead = FALSE, parallelism = c("none", "future",
  "parallel"), resample_specific_blocks = NULL,
  unique_resample_lim = NULL, narrowness_avoid = TRUE,
  num_cores = NULL, suppress_sampling_message = FALSE)

BootGlmm(base_model, resamples = 9999, base_data = NULL,
  return_coefs_instead = FALSE, resample_specific_blocks = NULL,
  unique_resample_lim = NULL, narrowness_avoid = TRUE,
  num_cores = NULL, suppress_sampling_message = FALSE,
  suppress_loading_bar = FALSE, allow_conv_error = FALSE)
}
\arguments{
\item{base_model}{The pre-bootstrap model, i.e. the model output
from running a standard model call.
Examples:
base_model <- glmmTMB(y ~ age + (1 | subj),
                      data = rel_data, family = binomial)
base_model <- lm(y ~ x, data = xy_frame)}

\item{base_data}{The data that was used in the call. You
can leave this to be automatically read, but
I highly recommend supplying it}

\item{resamples}{How many resamples of your data do you want to do?
9999 is a reasonable default (see Hesterberg 2015),
but start very small to make sure it works on
your data properly, and to get a rough timing estimate etc.}

\item{return_coefs_instead}{Logical, default FALSE: do you want the list of lists
of results for each bootstrap sample (set to TRUE), or the
matrix output of all samples? See return for more details.}

\item{parallelism}{What type of parallelism (if any) to use to run the resamples.
Options are:
- "none"      the default
- "future"    to use future.apply (`future`s)
- "parallel"  to use parallel::mclapply}

\item{resample_specific_blocks}{Character vector, default NULL. If left NULL,
  this algorithm with choose ONE random block to resample over -
  the one with the largest entropy (often the one with most levels).
  If you wish to
  resample over specific random effects as blocks, enter
  the names here - can be one, or many. Note that resampling
  multiple blocks is in general quite conservative.

  If you want to perform case resampling but you DO have
  random effects, set resample_specific_blocks to any
  non-null value that isn't equal to a random effect
  variable name.}

\item{unique_resample_lim}{Should be same length as number of random effects (or left NULL).
Do you want to force the resampling to produce a minimum number of
unique values in sampling? Don't make this too big...
Must be named same as rand cols}

\item{narrowness_avoid}{Boolean, default TRUE.
If TRUE, will resample n-1 instead of n elements
in the bootstrap (n being either rows, or random effect levels,
depending on existence of random effects). If FALSE, will do
typical size n resampling.}

\item{num_cores}{Defaults to parallel::detectCores() - 1 if parallelism = "parallel"}

\item{suppress_sampling_message}{Logical, default FALSE. By default, this function
will message the console with the type of bootstrapping:
block resampling over random effects - in which case it'll say
what effect it's sampling over;
case resampling - in which case it'll say as much.
Set TRUE to hide message.}

\item{suppress_loading_bar}{defunct now}

\item{allow_conv_error}{defunct now}
}
\value{
By default, returns the output from bootstrap_ci:
    - for each set of covariates (usually just the one set,
      the conditional model), a matrix of output, a row for each variable,
      including the intercept
      (estimate, CIs for boot and base, p-values).
  If return_coefs_instead = TRUE, then will instead
  return a list of length two:
  [[1]] will be a list containing the output for the base model
  [[2]] will be a list of length resamples,
  each a list of matrices of estimates and standard errors for each model.
  This output is useful for error checking, and if you want
  to run this function in certain distributed ways.
}
\description{
By default, this will compute bootstrap resamples
and then send them to `bootstrap_ci`
for calculation. Note - only use parallel methods if your
model is expensive to build, otherwise the overhead won't be worth it.
}
\examples{
x <- rnorm(20)
y <- rnorm(20) + x
xy_data = data.frame(x = x, y = y)
first_model <- lm(y ~ x, data = xy_data)

out_matrix <- bootstrap_model(first_model, base_data = xy_data, 20)
out_list <- bootstrap_model(first_model,
                            base_data = xy_data,
                            resamples = 20,
                            return_coefs_instead = TRUE)

\donttest{
  data(test_data)
  library(glmmTMB)
  test_formula <- as.formula('y ~ x_var1 + x_var2 + x_var3 + (1|subj)')
  test_model <- glmmTMB(test_formula, data = test_data, family = binomial)
  output_matrix <- bootstrap_model(test_model, base_data = test_data, 199)

  output_lists <- bootstrap_model(test_model,
                                  base_data = test_data,
                                  resamples = 199,
                                  return_coefs_instead = TRUE)
}

}
