% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap_methods.R
\name{get_rand}
\alias{get_rand}
\title{Takes in a formula with bars
and gives back the plain names of the columns}
\usage{
get_rand(form_with_bars)
}
\arguments{
\item{form_with_bars}{A formula used in e.g. \code{lme4} and similar
packages. Typically along the lines:
\code{y ~ age + (1 | school)} etc}
}
\value{
A vector of the variables that are treated as random.
}
\description{
Takes in a formula with bars
and gives back the plain names of the columns
}
\examples{
get_rand("y ~ age + (1 | school)")
get_rand("y ~ income + (1 | school) + (1 | school:section)")
get_rand("y ~ income + (1 | school) + (1 | school/section)")
get_rand(as.formula("y ~ x + (1 | z)"))
get_rand("y ~ x")

}
