% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{brains}
\alias{brains}
\title{Mammal brain and body weights}
\format{
A data frame with 62 rows and 3 variables:
\describe{
  \item{Specie}{a character string giving the species name.}
  \item{BrainWt}{a numeric vector indicating the average brain weight, in grams.}
  \item{BodyWt}{a numeric vector indicating the average body weight, in kilograms.}
}
}
\usage{
data(brains)
}
\description{
These data corresponds to the (average) body weight and the
(average) brain weight for sixty-two species of mammals.
}
\examples{
with(brains, plot(log(BodyWt),log(BrainWt),pch=20,
               xlab="log(Body Weight)",ylab="log(Brain Weight)"))
}
\references{
Allison, T. and Cicchetti, D. (1976). Sleep in mammals: Ecology and constitutional correlates. \emph{Science} 194, 732-734.

Weisberg, S. (2005). \emph{Applied Linear Regression}, 3rd edition. Wiley, New York.
}
\keyword{datasets}
