% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/globalsOf.R
\name{globalsOf}
\alias{findGlobals}
\alias{globalsOf}
\title{Get all global objects of an expression}
\usage{
globalsOf(expr, envir = parent.frame(), ..., method = c("conservative",
  "liberal"), tweak = NULL, substitute = FALSE, mustExist = TRUE,
  unlist = TRUE)
}
\arguments{
\item{expr}{An R expression.}

\item{envir}{The environment from where to search for globals.}

\item{...}{Not used.}

\item{method}{A character string specifying what type of search algorithm to use.}

\item{tweak}{An optional function that takes an expression
and returns a tweaked expression.}

\item{substitute}{If TRUE, the expression is \code{substitute()}:ed,
otherwise not.}

\item{mustExist}{If TRUE, an error is thrown if the object of the
identified global cannot be located.  Otherwise, the global
is not returned.}

\item{unlist}{If TRUE, a list of unique objects is returned.
       If FALSE, a list of \code{length(expr)} sublists.}
}
\value{
A a \link{Globals}.
}
\description{
Get all global objects of an expression
}
\details{
There currently two methods for identifying global objects.

The \code{"conservative"} search method tries to keep the number
of false positive to a minimum, i.e. the identified objects are
most likely true global objects.  At the same time, there is
a risk that some true globals are not identified (see example).
This search method returns the exact same result as the
\code{\link[codetools]{findGlobals}()} function of the
\pkg{codetools} package.

The \code{"liberal"} search method tries to keep the
true-positive ratio as high as possible, i.e. the true globals
are most likely among the identified ones.  At the same time,
there is a risk that some false positives are also identified.
}
\examples{
b <- 2
expr <- substitute({ a <- b; b <- 1 })

## Will _not_ identify 'b' (because it's also a local)
globalsC <- globalsOf(expr, method="conservative")
print(globalsC)

## Will identify 'b'
globalsL <- globalsOf(expr, method="liberal")
print(globalsL)
}
\seealso{
Internally, the \pkg{\link{codetools}} package is utilized for
code inspections.
}

