% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_functions.R
\name{cv_bart}
\alias{cv_bart}
\title{Cross-Validation for BART Model}
\usage{
cv_bart(data, k = 10, seed = NULL)
}
\arguments{
\item{data}{Data frame with a column (named 'pa') indicating presence (1) or absence (0) and columns for the predictor variables.}

\item{k}{Integer; number of folds for cross-validation (default is 10).}

\item{seed}{Optional; random seed.}
}
\value{
A data frame containing the true positives (TP), false positives (FP), false negatives (FN), true negatives (TN),
and various performance metrics including precision (PREC), sensitivity (SEN), specificity (SPC), false discovery rate (FDR),
negative predictive value (NPV), false negative rate (FNR), false positive rate (FPR), F-score, accuracy (ACC), balanced accuracy (BA),
and true skill statistic (TSS) for each fold.
}
\description{
This function performs k-fold cross-validation for a Bayesian Additive Regression Trees (BART) model
using presence-absence data and environmental covariate layers. It calculates various performance metrics
for model evaluation.
}
