% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{inference}
\alias{inference}
\title{Perform inference in a Gaussian mixture Bayesian network}
\usage{
inference(
  gmbn,
  evid,
  nodes = names(gmbn),
  n_part = 1000,
  max_part_sim = 1e+06,
  verbose = FALSE
)
}
\arguments{
\item{gmbn}{A (non-temporal) object of class \code{gmbn}.}

\item{evid}{A data frame containing the evidence. Its columns must explicitly
be named after nodes of \code{gmbn} and can contain missing values (columns
with no value can be removed).}

\item{nodes}{A character vector containing the inferred nodes (by default all
the nodes of \code{gmbn}).}

\item{n_part}{A positive integer corresponding to the number of particles
generated for each observation.}

\item{max_part_sim}{An integer greater than or equal to \code{n_part}
corresponding to the maximum number of particles that can be processed
simultaneously. This argument is used to prevent memory overflow, dividing
\code{evid} into smaller subsets that are handled sequentially.}

\item{verbose}{A logical value indicating whether subsets of \code{evid} in
progress are displayed.}
}
\value{
A data frame (tibble) with a structure similar to \code{evid}
containing the estimated values of the inferred nodes.
}
\description{
This function performs inference in a (non-temporal) Gaussian mixture
Bayesian network. This task consists in estimating the state of the system
given partial observations of it (the evidence). Inference is performed by
likelihood weighting, which is a particle-based approximate method (Koller
and Friedman, 2009).
}
\examples{
\donttest{
set.seed(0)
data(gmbn_body, data_body)
evid <- data_body
evid$GENDER[sample.int(2148, 430)] <- NA
evid$AGE[sample.int(2148, 430)] <- NA
evid$HEIGHT[sample.int(2148, 430)] <- NA
evid$WEIGHT[sample.int(2148, 430)] <- NA
evid$FAT[sample.int(2148, 430)] <- NA
evid$WAIST[sample.int(2148, 430)] <- NA
evid$GLYCO[sample.int(2148, 430)] <- NA
infer <- inference(gmbn_body, evid, verbose = TRUE)}

}
\references{
Koller, D. and Friedman, N. (2009). \emph{Probabilistic Graphical Models:
Principles and Techniques}. The MIT Press.
}
\seealso{
\code{\link{filtering}}, \code{\link{prediction}},
\code{\link{smoothing}}
}
