% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_learn.R
\name{struct_learn}
\alias{struct_learn}
\title{Learn the structure and the parameters of a Gaussian mixture graphical model}
\usage{
struct_learn(
  gmgm,
  data,
  nodes = structure(gmgm)$nodes,
  arcs_cand = tibble(lag = 0),
  col_seq = NULL,
  score = "bic",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{gmgm}{An initial object of class \code{gmbn} or \code{gmdbn}.}

\item{data}{A data frame containing the data used for learning. Its columns
must explicitly be named after the nodes of \code{gmgm} and must not contain
missing values.}

\item{nodes}{A character vector containing the nodes whose local conditional
models are learned (by default all the nodes of \code{gmgm}). If \code{gmgm}
is a \code{gmdbn} object, the same nodes are learned for each of its
\code{gmbn} elements. This constraint can be overcome by passing a list of
character vectors named after some of these elements (\code{b_1}, \dots) and
containing learned nodes specific to them.}

\item{arcs_cand}{A data frame containing the candidate arcs for addition or
removal (by default all possible non-temporal arcs). The column \code{from}
describes the start node, the column \code{to} the end node and the column
\code{lag} the time lag between them. Missing values in \code{from} or
\code{to} are interpreted as "all possible nodes", which allows to quickly
define large set of arcs that share common attributes. Missing values in
\code{lag} are replaced by 0. If \code{gmgm} is a \code{gmdbn} object, the
same candidate arcs are used for each of its \code{gmbn} elements. This
constraint can be overcome by passing a list of data frames named after some
of these elements (\code{b_1}, \dots) and containing candidate arcs specific
to them. If arcs already in \code{gmgm} are not candidates, they cannot be
removed. Therefore, setting \code{arcs_cand} to \code{NULL} is equivalent to
learning only the mixture structure (and the parameters) of the model.}

\item{col_seq}{A character vector containing the column names of \code{data}
that describe the observation sequence. If \code{NULL} (the default), all the
observations belong to a single sequence. If \code{gmgm} is a temporal
\code{gmbn} or \code{gmdbn} object, the observations of a same sequence must
be ordered such that the \eqn{t}th one is related to time slice \eqn{t} (note
that the sequences can have different lengths). If \code{gmgm} is a
non-temporal \code{gmbn} object, this argument is ignored.}

\item{score}{A character string (\code{"aic"}, \code{"bic"} or
\code{"loglik"}) corresponding to the scoring function.}

\item{verbose}{A logical value indicating whether learned nodes in progress
are displayed.}

\item{\dots}{Additional arguments passed to function \code{\link{stepwise}}.}
}
\value{
A list with elements:
\item{gmgm}{The final \code{gmbn} or \code{gmdbn} object.}
\item{evol_score}{A list with elements:
\describe{
\item{\code{global}}{A numeric vector containing the global score before and
after learning.}
\item{\code{local}}{For a \code{gmbn} object, a numeric matrix containing the
local conditional scores before and after learning. For a \code{gmdbn}
object, a list of numeric matrices containing these values for each
\code{gmbn} element.}
}}
}
\description{
This function learns the (graphical and mixture) structure and the parameters
of a Gaussian mixture graphical model. Using the local decomposability of the
scoring function, this task consists in learning each local conditional model
independently with the stepwise algorithm (Koller and Friedman, 2009). Note
that some candidate arcs may be discarded to avoid that the global graphical
structure contains cycles. To limit recourse to this action, the learning
process is performed sequentially. The more arcs of a local model are likely
to be part of cycles (considering the worst case where all the candidate arcs
are selected), the later this local model is processed. By gradually taking
into account the local structures learned over time, the number of possible
cycles decreases and, with it, the number of candidate arcs to discard.
}
\examples{
\donttest{
data(data_body)
gmbn_1 <- add_nodes(NULL,
                    c("AGE", "FAT", "GENDER", "GLYCO", "HEIGHT", "WAIST",
                      "WEIGHT"))
arcs_cand_1 <- data.frame(from = c("AGE", "GENDER", "HEIGHT", "WEIGHT", NA,
                                   "AGE", "GENDER", "AGE", "FAT", "GENDER",
                                   "HEIGHT", "WEIGHT", "AGE", "GENDER",
                                   "HEIGHT"),
                          to = c("FAT", "FAT", "FAT", "FAT", "GLYCO", "HEIGHT",
                                 "HEIGHT", "WAIST", "WAIST", "WAIST", "WAIST",
                                 "WAIST", "WEIGHT", "WEIGHT", "WEIGHT"))
res_learn_1 <- struct_learn(gmbn_1, data_body, arcs_cand = arcs_cand_1,
                            verbose = TRUE, max_comp = 3)

data(data_air)
gmdbn_1 <- gmdbn(b_2 = add_nodes(NULL, c("NO2", "O3", "TEMP", "WIND")),
                 b_13 = add_nodes(NULL, c("NO2", "O3", "TEMP", "WIND")))
arcs_cand_2 <- data.frame(from = c("NO2", "NO2", "NO2", "O3", "TEMP", "TEMP",
                                   "WIND", "WIND"),
                          to = c("NO2", "O3", "O3", "O3", NA, NA, NA, NA),
                          lag = c(1, 0, 1, 1, 0, 1, 0, 1))
res_learn_2 <- struct_learn(gmdbn_1, data_air, arcs_cand = arcs_cand_2,
                            col_seq = "DATE", verbose = TRUE, max_comp = 3)}

}
\references{
Koller, D. and Friedman, N. (2009). \emph{Probabilistic Graphical Models:
Principles and Techniques}. The MIT Press.
}
\seealso{
\code{\link{param_em}}, \code{\link{param_learn}},
\code{\link{struct_em}}
}
