% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMVARconstruction.R
\name{swap_parametrization}
\alias{swap_parametrization}
\title{Swap the parametrization of object of class 'gmvar' defining a GMVAR model}
\usage{
swap_parametrization(gmvar)
}
\arguments{
\item{gmvar}{object of class \code{'gmvar'}, generated by function \code{fitGMVAR()} or \code{GMVAR()}.}
}
\value{
Returns an object of class \code{'gmvar'} defining the specified GMVAR model. Can be used
  to work with other functions provided in \code{gmvarkit}.
}
\description{
\code{swap_parametrization} swaps the parametrization of object of class '\code{gmvar}'
 to \code{"mean"} if the currect parametrization is \code{"intercept"}, and vice versa.
}
\details{
\code{swap_parametrization()} is convenient tool if you have estimated the model in
 "intercept"-parametrization, but wish to work with "mean"-parametrization in the future, or vice versa.
 In \code{gmvarkit}, for example the approximate standard errors are only available for
 parametrized parameters.
}
\examples{
\donttest{
# These examples use the data 'eurusd' which comes with the
# package, but in a scaled form.
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# GMVAR(1,2), d=2 model:
params122 <- c(0.623, -0.129, 0.959, 0.089, -0.006, 1.006, 1.746,
 0.804, 5.804, 3.245, 7.913, 0.952, -0.037, -0.019, 0.943, 6.926,
 3.982, 12.135, 0.789)
mod122 <- GMVAR(data, p=1, M=2, params=params122)
mod122 # intercept-parametrization

mod122_2 <- swap_parametrization(mod122)
mod122_2 # mean-parametrization


# GMVAR(2,2), d=2 model:
params222 <- c(-11.904, 154.684, 1.314, 0.145, 0.094, 1.292, -0.389,
 -0.070, -0.109, -0.281, 0.920, -0.025, 4.839, 11.633, 124.983, 1.248,
  0.077, -0.040, 1.266, -0.272, -0.074, 0.034, -0.313, 5.855, 3.570,
  9.838, 0.740)
mod222 <- GMVAR(data, p=2, M=2, params=params222, parametrization="mean")
mod222 # mean-parametrization

mod222_2 <- swap_parametrization(mod222)
mod222_2 # intercept-parametrization
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Kalliovirta L. and Saikkonen P. 2010. Reliable Residuals for Multivariate Nonlinear
         Time Series Models. \emph{Unpublished Revision of HECER Discussion Paper No. 247}.
 }
}
\seealso{
\code{\link{fitGMVAR}}, \code{\link{GMVAR}}, \code{\link{iterate_more}}
}
