% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosticPlot.R
\name{profile_logliks}
\alias{profile_logliks}
\title{Plot profile log-likehoods around the estimates}
\usage{
profile_logliks(
  gmvar,
  which_pars,
  scale = 0.02,
  nrows,
  ncols,
  precission = 200,
  stat_tol = 0.001,
  posdef_tol = 1e-08
)
}
\arguments{
\item{gmvar}{an object of class \code{'gmvar'} created with \code{fitGMVAR} or \code{GMVAR}.}

\item{which_pars}{the profile log-likelihood function of which parameters should be plotted? An integer
 vector specifying the positions of the parameters in the parameter vector. The parameter vector has the
 form...
  \describe{
    \item{\strong{For unconstrained models:}}{
      Should be size \eqn{((M(pd^2+d+d(d+1)/2+1)-1)x1)} and have form
      \strong{\eqn{\theta}}\eqn{ = }(\strong{\eqn{\upsilon}}\eqn{_{1}},
      ...,\strong{\eqn{\upsilon}}\eqn{_{M}}, \eqn{\alpha_{1},...,\alpha_{M-1}}), where:
      \itemize{
        \item \strong{\eqn{\upsilon}}\eqn{_{m}} \eqn{ = (\phi_{m,0},}\strong{\eqn{\phi}}\eqn{_{m}}\eqn{,\sigma_{m})}
        \item \strong{\eqn{\phi}}\eqn{_{m}}\eqn{ = (vec(A_{m,1}),...,vec(A_{m,p})}
        \item and \eqn{\sigma_{m} = vech(\Omega_{m})}, m=1,...,M.
      }
    }
    \item{\strong{For constrained models:}}{
      Should be size \eqn{((M(d+d(d+1)/2+1)+q-1)x1)} and have form
      \strong{\eqn{\theta}}\eqn{ = (\phi_{1,0},...,\phi_{M,0},}\strong{\eqn{\psi}}
      \eqn{,\sigma_{1},...,\sigma_{M},\alpha_{1},...,\alpha_{M-1})}, where:
      \itemize{
        \item \strong{\eqn{\psi}} \eqn{(qx1)} satisfies (\strong{\eqn{\phi}}\eqn{_{1}}\eqn{,...,}
        \strong{\eqn{\phi}}\eqn{_{M}) =} \strong{\eqn{C \psi}}. Here \strong{\eqn{C}} is \eqn{(Mpd^2xq)}
        constraint matrix.
      }
    }
  }
  Above, \eqn{\phi_{m,0}} is the intercept parameter, \eqn{A_{m,i}} denotes the \eqn{i}:th coefficient matrix of the \eqn{m}:th
  mixture component, \eqn{\Omega_{m}} denotes the error term covariance matrix of the \eqn{m}:th mixture component, and
  \eqn{\alpha_{m}} is the mixing weight parameter.

  The default is that profile log-likelihood functions for all parameters are plotted.}

\item{scale}{a numeric scalar specifying the interval plotted for each estimate:
the estimate plus-minus \code{abs(scale*estimate)}.}

\item{nrows}{how many rows should be in the plot-matrix? The default is \code{max(ceiling(log2(length(which_pars)) - 1), 1)}.}

\item{ncols}{how many columns should be in the plot-matrix? The default is \code{ceiling(length(which_pars)/nrows)}.
Note that \code{nrows*ncols} should not be smaller than the length of \code{which_pars}.}

\item{precission}{at how many points should each profile log-likelihood be evaluated at?}

\item{stat_tol}{numerical tolerance for stationarity of the AR parameters: if the "bold A" matrix of any regime
has eigenvalues larger that \code{1 - stat_tol} the model is classified as non-stationary. Note that if the
tolerance is too small, numerical evaluation of the log-likelihood might fail and cause error.}

\item{posdef_tol}{numerical tolerance for positive definiteness of the error term covariance matrices: if
the error term covariance matrix of any regime has eigenvalues smaller than this, the model is classified
as not satisfying positive definiteness assumption. Note that if the tolerance is too small, numerical
evaluation of the log-likelihood might fail and cause error.}
}
\value{
Only plots to a graphical device and doesn't return anything.
}
\description{
\code{profile_logliks} plots profile log-likelihoods around the estimates.
}
\details{
When the number of parameters is large, it might be better to plot a smaller number of profile
 log-likelihood functions at a time using the argument \code{which_pars}.

The red vertical line points the estimate.
}
\examples{
\donttest{
# Running all the below examples takes approximately 2 minutes.

# These examples use the data 'eurusd' which comes with the
# package, but in a scaled form (similar to Kalliovirta et al. 2016).
data(eurusd, package="gmvarkit")
data <- cbind(10*eurusd[,1], 100*eurusd[,2])
colnames(data) <- colnames(eurusd)

# GMVAR(1,2) model
fit12 <- fitGMVAR(data, p=1, M=2, ncalls=1, seeds=7)
fit12
profile_logliks(fit12)

# Structural GMVAR(1,2) model identified with sign
# constraints: model build based on inaccurate hand-given estimates.
W_122 <- matrix(c(1, 1, -1, 1), nrow=2)
params12s <- c(0.62, -0.13, 3.25, 7.92, 0.96, 0.09, -0.01, 1.01, 0.95, -0.04,
               -0.02, 0.94, 1.31, 0.88, -0.16, 2.24, 4, 1.8, 0.79)
fit12s <- GMVAR(data, p=1, M=2, params=params12s,
                structural_pars=list(W=W_122))
profile_logliks(fit12s)
}
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Lütkepohl H. 2005. New Introduction to Multiple Time Series Analysis,
         \emph{Springer}.
   \item McElroy T. 2017. Computation of vector ARMA autocovariances.
         \emph{Statistics and Probability Letters}, \strong{124}, 92-96.
   \item Virolainen S. 2020. Structural Gaussian mixture vector autoregressive model. Unpublished working
         paper, available as arXiv:2007.04713.
 }
}
\seealso{
\code{\link{get_soc}}, \code{\link{diagnostic_plot}}, \code{\link{fitGMVAR}}, \code{\link{GMVAR}},
  \code{\link{GIRF}}, \code{\link{LR_test}}, \code{\link{Wald_test}}, \code{\link{cond_moment_plot}}
}
