% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMethods.R
\name{plot.gsmvarpred}
\alias{plot.gsmvarpred}
\title{plot method for class 'gsmvarpred' objects}
\usage{
\method{plot}{gsmvarpred}(x, ..., nt, mix_weights = TRUE, add_grid = TRUE)
}
\arguments{
\item{x}{object of class \code{'gsmvarpred'} generated by \code{predict.gsmvar}.}

\item{...}{arguments passed to \code{grid} which plots grid to the figure.}

\item{nt}{a positive integer specifying the number of observations to be plotted
along with the prediction (ignored if \code{plot_res==FALSE}). Default is \code{round(nrow(data)*0.15)}.}

\item{mix_weights}{\code{TRUE} if forecasts for mixing weights should be plotted,
\code{FALSE} in not.}

\item{add_grid}{should grid be added to the plots?}
}
\description{
\code{plot.gsmvarpred} is plot method for gsmvarpred objects.
}
\details{
This method is used plot forecasts of GSMVAR processes
}
\references{
\itemize{
   \item Kalliovirta L., Meitz M. and Saikkonen P. 2016. Gaussian mixture vector autoregression.
         \emph{Journal of Econometrics}, \strong{192}, 485-498.
   \item Virolainen S. 2022. Structural Gaussian mixture vector autoregressive model with application to the asymmetric
     effects of monetary policy shocks. Unpublished working paper, available as arXiv:2007.04713.
   \item Virolainen S. 2022. Gaussian and Student's t mixture vector autoregressive model with application to the
     asymmetric effects of monetary policy shocks in the Euro area. Unpublished working
     paper, available as arXiv:2109.13648.
 }
 @keywords internal
}
