% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection_methods.R
\name{auto.imu}
\alias{auto.imu}
\title{Automatically select appropriate model for IMU}
\usage{
auto.imu(data, model = 3 * AR1() + WN() + RW() + QN() + DR(), bootstrap = F,
  alpha = 0.05, robust = F, eff = 0.6, B = 50, G = 1e+05,
  seed = 1337)
}
\arguments{
\item{data}{A \code{vector}, \code{matrix}, \code{data.frame}, or \code{imu} object with either 1, 3, or 6 columns.}

\item{model}{A \code{ts.model} object that is the largest model to be tested.}

\item{bootstrap}{A \code{bool} that is either true or false to indicate whether we use bootstrap or asymptotic By default, we use asymptotic.}

\item{alpha}{A \code{double} that indicates the level of confidence for the WV CI.}

\item{robust}{A \code{boolean} that indicates whether to use robust estimation.}

\item{eff}{A \code{double} between 0 and 1 that indicates the efficiency for the robust estimation.}

\item{B}{A \code{integer} that contains the amount of bootstrap replications}

\item{G}{A \code{integer} that indicates the amount of guesses for caliberating the startup.}

\item{seed}{A \code{integer} that controls the reproducibility of the auto model selection phase.}
}
\value{
A \code{auto.imu} object.
}
\description{
Runs through a model selection algorithm to determine the best model
}

