% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{arma_to_wv_app}
\alias{arma_to_wv_app}
\title{ARMA process to WV approximation}
\usage{
arma_to_wv_app(ar, ma, tau, sigma, alpha = 0.9999)
}
\arguments{
\item{ar}{A \code{vec} containing the coefficients of the AR process}

\item{ma}{A \code{vec} containing the coefficients of the MA process}

\item{tau}{A \code{vec} containing the scales e.g. 2^tau}

\item{sigma}{A \code{double} containing the residual variance}

\item{alpha}{A \code{double} indicating the cutoff.}
}
\value{
A \code{vec} containing the wavelet variance of the ARMA process.
}
\description{
This function computes the (haar) WV of an ARMA process
}
\examples{
arma_to_wv_app(c(.23,.43), c(.34,.41,.59), 2^(1:9), 3, .9)
}
\seealso{
\code{\link{ARMAtoMA_cpp}},\code{\link{ARMAacf_cpp}}
}
\keyword{internal}

