% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_genesets.R
\name{save_genesets}
\alias{save_genesets}
\title{Write a geneset table to file.}
\usage{
save_genesets(x, genelist, filename, arrange_genes = TRUE)
}
\arguments{
\item{x}{result from \code{filter_genesets()}, \code{test_genesets()} or \code{simplify_genesets()}. When saving the latter, output will include clusters assigned to each significant geneset}

\item{genelist}{same as provided for \code{test_genesets()}. A column named 'symbol' is required, it'll be used to pretty-print gene symbols per geneset in the output table}

\item{filename}{full path to the output file. Supported file extensions; csv, tsv, xlsx. Optionally, set to NA to not write to disk and return the result table instead}

\item{arrange_genes}{set to TRUE (default) to arrange the genelist table by best p-value on top (if column 'pvalue' exists), alternatively by descending absolute effectsize (if no pvalue but effectize is available). Set FALSE to use sorting of the genelist table as-is}
}
\value{
if \code{filename} is \code{NA}, returns the validated and formatted geneset result table. Otherwise, writes the table to file and does not return a value
}
\description{
Works for any filtered geneset table generated by this package, e.g. results from any of these functions;
\code{filter_genesets()}, \code{test_genesets()} or \code{simplify_genesets()}.

The genelist table is required to 1) lookup gene symbols and 2) determine the ordering of genes within-geneset.
The latter makes it such that the output table shows the most important genes (in context of user's data) first.

All output columns that list gene identifiers or symbols are trimmed to 25000 characters. Depending on your input
gene identifier type and dataset filtering settings (e.g. max geneset size), this might lead to some truncation.
For example, 15 characters per ensembl gene ID (if these are used in provided genesets instead of default NCBI
Entrez) and 1 char as delimiter, only the top ~1500 ensembl gene identifiers are included. If your geneset
filtering allows for larger genesets and you want to check if any gene identifiers are lost upon saving,
keep an eye out for the trailing ellipsis ('...'). Because genes in each geneset of the output table are sorted
by order of importance as indicated in the genelist table, this shouldn't be an issue in typical use-cases
where the output table is to check the topN most important/significant genes of a geneset of interest.
}
