% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_stopwords.R
\name{remove_stopwords}
\alias{prep_stopwords}
\alias{remove_stopwords}
\title{Remove Stopwords from a TermDocumentMatrix/DocumentTermMatrix}
\usage{
remove_stopwords(x, stopwords = tm::stopwords("english"), min.char = 3,
  max.char = NULL, stem = FALSE, denumber = TRUE)

prep_stopwords(...)
}
\arguments{
\item{x}{A \code{\link[tm]{TermDocumentMatrix}} or \code{\link[tm]{DocumentTermMatrix}}.}

\item{stopwords}{A vector of stopwords to remove.}

\item{min.char}{The minimal length character for retained words.}

\item{max.char}{The maximum length character for retained words.}

\item{stem}{Logical.  If \code{TRUE} the \code{stopwords} will be stemmed.}

\item{denumber}{Logical.  If \code{TRUE} numbers will be excluded.}

\item{\dots}{\code{\link[base]{vector}}s of words.}
}
\value{
Returns a \code{\link[tm]{TermDocumentMatrix}} or \code{\link[tm]{DocumentTermMatrix}}.
}
\description{
\code{remove_stopwords} - Remove stopwords and < nchar words from a
\code{\link[tm]{TermDocumentMatrix}} or \code{\link[tm]{DocumentTermMatrix}}.

\code{prep_stopwords} - Join multiple vectors of words, convert to lower case,
and return sorted unique words.
}
\examples{
(x <-with(presidential_debates_2012, q_dtm(dialogue, paste(time, tot, sep = "_"))))
remove_stopwords(x)
(y <- with(presidential_debates_2012, q_tdm(dialogue, paste(time, tot, sep = "_"))))
remove_stopwords(y)

prep_stopwords("the", "ChIcken", "Hello", tm::stopwords("english"), c("John", "Josh"))
}
\keyword{stopwords}

