% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segments.R
\name{segment_element}
\alias{segment_element}
\title{Make a segment element}
\usage{
segment_element(
  name,
  operator = c("REGEXP", "BEGINS_WITH", "ENDS_WITH", "PARTIAL", "EXACT", "IN_LIST",
    "NUMERIC_LESS_THAN", "NUMERIC_GREATER_THAN", "NUMERIC_BETWEEN", "LESS_THAN",
    "GREATER_THAN", "EQUAL", "BETWEEN"),
  type = c("METRIC", "DIMENSION"),
  not = FALSE,
  expressions = NULL,
  caseSensitive = NULL,
  minComparisonValue = NULL,
  maxComparisonValue = NULL,
  scope = c("SESSION", "USER", "HIT", "PRODUCT"),
  comparisonValue = NULL,
  matchType = c("PRECEDES", "IMMEDIATELY_PRECEDES")
)
}
\arguments{
\item{name}{Name of the GA metric or dimension to segment on}

\item{operator}{How name shall operate on expression or comparisonValue}

\item{type}{A metric or dimension based segment element}

\item{not}{Should the element be the negation of what is defined}

\item{expressions}{\code{dim} What the name shall compare to}

\item{caseSensitive}{\code{dim} Whether to be case sensitive}

\item{minComparisonValue}{\code{dim} Minimum comparison values for BETWEEN}

\item{maxComparisonValue}{Max comparison value for BETWEEN operator}

\item{scope}{\code{met} Scope of the metric value}

\item{comparisonValue}{\code{met} What the name shall compare to}

\item{matchType}{If used in sequence segment, what behaviour}
}
\value{
A SegmentFilterClause object
}
\description{
\code{segment_element} is the lowest hierarchy of segment creation, for which you will also need:
\itemize{
\item \link{segment_define} : AND combination of segmentFilters
\item \link{segment_vector_simple} or \link{segment_vector_sequence}
\item \link{segment_element} that are combined in OR lists for \verb{segment_vectors_*}
}
}
\seealso{
Other v4 segment functions: 
\code{\link{segment_define}()},
\code{\link{segment_ga4}},
\code{\link{segment_vector_sequence}()},
\code{\link{segment_vector_simple}()}
}
\concept{v4 segment functions}
