% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{gtm_variables_revert}
\alias{gtm_variables_revert}
\title{Reverts a variable to its original state}
\usage{
gtm_variables_revert(account_id, container_id, workspace_id, variable_id)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{variable_id}{Variable Id}
}
\description{
This reverts a variable back to its original, unmodified state.
}
\examples{

\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 10
variableId <- 102

variable <- gtm_variables_revert(accountId, containerId, workspaceId, variableId)

# Changes to variable 22 have been reverted
}

}
\seealso{
\url{https://developers.google.com/tag-manager/api/v2/reference/accounts/containers/workspaces/variables/revert}

Other variable functions: 
\code{\link{gtm_variables_create}()},
\code{\link{gtm_variables_delete}()},
\code{\link{gtm_variables_get}()},
\code{\link{gtm_variables_list}()},
\code{\link{gtm_variables_update}()}
}
\concept{variable functions}
