% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_map_layer_polyline.R
\name{add_polylines}
\alias{add_polylines}
\title{Add polyline}
\usage{
add_polylines(map, data = get_map_data(map), polyline = NULL, lat = NULL,
  lon = NULL, id = NULL, geodesic = NULL, stroke_colour = NULL,
  stroke_weight = NULL, stroke_opacity = NULL, info_window = NULL,
  mouse_over = NULL, mouse_over_group = NULL, draggable = NULL,
  editable = NULL, update_map_view = TRUE, layer_id = NULL,
  z_index = NULL, digits = 4, palette = NULL, legend = F,
  legend_options = NULL, load_interval = 0, focus_layer = FALSE)
}
\arguments{
\item{map}{a googleway map object created from \code{google_map()}}

\item{data}{data frame containing at least a \code{polyline} column,
or a \code{lat} and a \code{lon} column. If Null, the data passed into
\code{google_map()} will be used.}

\item{polyline}{string specifying the column of \code{data} containing
the encoded polyline}

\item{lat}{string specifying the column of \code{data} containing the 'latitude'
coordinates. If left NULL, a best-guess will be made}

\item{lon}{string specifying the column of \code{data} containing the 'longitude'
coordinates. If left NULL, a best-guess will be made}

\item{id}{string specifying the column containing an identifier for a shape}

\item{geodesic}{logical}

\item{stroke_colour}{either a string specifying the column of \code{data} containing
the stroke colour of each shape, or a valid hexadecimal numeric HTML style to
be applied to all the shapes}

\item{stroke_weight}{either a string specifying the column of \code{data} containing
the stroke weight of each shape, or a number indicating the width of pixels
in the line to be applied to all the shapes}

\item{stroke_opacity}{either a string specifying the column of \code{data} containing
the stroke opacity of each shape, or a value between 0 and 1 that will be
applied to all the shapes}

\item{info_window}{string specifying the column of data to display in an info
window when a shape is clicked.}

\item{mouse_over}{string specifying the column of data to display when the
mouse rolls over the shape}

\item{mouse_over_group}{string specifying the column of data specifying which
groups of shapes to highlight on mouseover}

\item{draggable}{string specifying the column of \code{data} defining if
the polygon is 'draggable'. The column of data should be logical (either TRUE or FALSE)}

\item{editable}{string specifying the column of \code{data} defining if the polygon
is 'editable' (either TRUE or FALSE)}

\item{update_map_view}{logical specifying if the map should re-centre according to
the shapes}

\item{layer_id}{single value specifying an id for the layer. Use this value to
distinguish between shape layers for when using any \code{update_} function, and
for separating legends.}

\item{z_index}{single value specifying where the circles appear in the layering
of the map objects. Layers with a higher \code{z_index} appear on top of those with
a lower \code{z_index}. See details.}

\item{digits}{integer. Use this parameter to specify how many digits (decimal places)
should be used for the latitude / longitude coordinates.}

\item{palette}{a function, or list of functions, that generates hex colours
given a single number as an input. See details.}

\item{legend}{either a logical indiciating if the legend(s) should be displayed, or
a named list indicating which colour attributes should be included in the legend.}

\item{legend_options}{A list of options for controlling the legend.}

\item{load_interval}{time in miliseconds to wait between plotting each shape}

\item{focus_layer}{logical indicating if the map should re-centre according to this layer}
}
\description{
Add a polyline to a google map
}
\details{
\code{z_index} values define the order in which objects appear on the map.
Those with a higher value appear on top of those with a lower value. The default
order of objects is (1 being underneath all other objects)

\itemize{
  \item{1. Polygon}
  \item{2. Rectangle}
  \item{3. Polyline}
  \item{4. Circle}
}

Markers are always the top layer
}
\note{
The lines can be generated by either using an encoded polyline, or by a
set of lat/lon coordinates.
You sould specify either the column containing an encoded polyline, OR the
lat / lon colulmns.

Using \code{update_map_view = TRUE} for multiple polylines may be slow, so it
may be more appropriate to set the view of the map using the location argument
of \code{google_map()}
}
\section{palette}{


The \code{palette} is used to specify the colours that will map to variables.
You can specify a single function to map to all variables, or a named list
that specifies a separate function to map to each variable. The elements must
be named either \code{fill_colour} or \code{stroke_colour}, and their values
are the colour generating functions. The default is \code{viridisLite::viridis}

The \code{legend_options} can be used to control the appearance of the legend.
This should be a named list, where the names are one of
\itemize{
  \item{position - one of \code{c("TOP_LEFT", "TOP_CENTER", "TOP_RIGHT", "RIGHT_TOP",
  "RIGHT_CENTER", "RIGHT_BOTTOM", "BOTTOM_RIGHT", "BOTTOM_CENTER", "BOTTOM_LEFT",
  "LEFT_BOTTOM", "LEFT_CENTER", "LEFT_TOP")}}
  \item{css - a string of valid \code{css} for controlling the appearance of the legend}
  \item{title - a string to use for the title of the legend}
}
if \code{legend_options} are NULL, the default values will apply

If you are displaying two legends, one for \code{stroke_colour} and one
for \code{fill_colour}, you can specify different options for the different
colour attributes. See examples for \link{add_circles}.
}

\examples{
\dontrun{

## using lat/lon coordinates

set_key("your_api_key")

google_map(data = tram_route) \%>\%
  add_polylines(lat = "shape_pt_lat", lon = "shape_pt_lon")


google_map() \%>\%
  add_polylines(data = melbourne, polyline = "polyline", stroke_weight = 1,
      stroke_colour = "SA4_NAME")

## using encoded polyline and various colour / fill options
url <- 'https://raw.githubusercontent.com/plotly/datasets/master/2011_february_aa_flight_paths.csv'
flights <- read.csv(url)
flights$id <- seq_len(nrow(flights))


## encode the routes as polylines
lst <- lapply(unique(flights$id), function(x){
  lat = c(flights[flights["id"] == x, c("start_lat")], flights[flights["id"] == x, c("end_lat")])
  lon = c(flights[flights["id"] == x, c("start_lon")], flights[flights["id"] == x, c("end_lon")])
  data.frame(id = x, polyline = encode_pl(lat = lat, lon = lon))
})

flights <- merge(flights, do.call(rbind, lst), by = "id")

style <- map_styles()$night

google_map(key = map_key, style = style) \%>\%
  add_polylines(data = flights, polyline = "polyline", mouse_over_group = "airport1",
               stroke_weight = 1, stroke_opacity = 0.3, stroke_colour = "#ccffff")


}
}
