% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/goxygen.R
\name{goxygen}
\alias{goxygen}
\title{goxygen}
\usage{
goxygen(
  path = ".",
  docfolder = "doc",
  cache = FALSE,
  output = c("html", "tex", "pdf"),
  htmlStyle = "ming",
  cff = "CITATION.cff",
  modularCode = is.modularGAMS(),
  unitPattern = c("\\\\(", "\\\\)"),
  includeCore = FALSE,
  mainfile = "main.gms",
  ...
)
}
\arguments{
\item{path}{path to the model to be documented}

\item{docfolder}{folder the documentation should be written to relative to model folder}

\item{cache}{Boolean to allow read data from existing cache file}

\item{output}{List of output to be written, available are "html","pdf" and "tex"}

\item{htmlStyle}{visualization style to be used for the HTML creation. Currently available styles are 
"classic" and "ming". Ignored for outputs other than HTML.}

\item{cff}{path to a citation file in citation-file-format (ignored if not existing)}

\item{modularCode}{Boolean deciding whether code should be interpreted as modular GAMS code (only av)}

\item{unitPattern}{pattern that is usedto identify the unit in the description, default =c("\\(","\\)")}

\item{includeCore}{boolean whether core should be included or not, default=FALSE}

\item{mainfile}{main file of the model}

\item{...}{optional arguments to \code{\link[gms]{interfaceplot}}, passed via \code{\link[gms]{modules_interfaceplot}}.}
}
\description{
Documentation function which extracts a full model documentation from a 
modularized gams model. The function extracts comments used as documentation,
extracts code and can extract and convert GAMS equations as latex code. Output
is returned in Markdown, HTML and PDF format.
}
\note{
Documentation lines in the code must start with *' to be detected as documentation.
Identifier at the beginning of each block describe what kind of documentation is given. 
All identifiers start with @ followed by the name of the identifier. Currently, following
identifiers are available
\itemize{
 \item @title Title 
 \item @authors List of authors
 \item @description Model description (only the documentation text will be interpreted)
 \item @equations Equation description (documentation text will be extracted and gams equations
 will be converted to latex code)
 \item @code Code description (documentation text and code will be extracted)
 \item @limitations details about limitations of an implementation
 \item @stop everything following will be ignored until the next identifier is mentioned again. Useful
 to stop a section
}

In addition you can store a model logo (100px height, 100px weight) as \code{logo.png} in the main
folder of the model which then will be used in the HTML version of the documentation.
If you want to add citations to your documentation you can do so by adding a bibtex file with 
the name literature.bib in the main folder of the model. To link these references in the text
you can use the syntax \code{@<id>} in which "<id>" stands for the identifier given to the 
corresponding bibtex entry.
}
\examples{
# run goxygen for dummy model and store documentation as HTML in a temporary directory
docfolder <- paste0(tempdir(),"/doc")
goxygen(system.file("dummymodel",package="gms"),  docfolder=docfolder, output="html")
}
\seealso{
\code{\link{codeCheck}},\code{\link[gms]{interfaceplot}}
}
\author{
Jan Philipp Dietrich
}
