% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltcmt.R
\name{ltcmt}
\alias{ltcmt}
\title{Analysis of Line x Tester data for multiple traits containing only Crosses laid out in RCBD or Alpha Lattice design.}
\usage{
ltcmt(data, replication, line, tester, traits, block)
}
\arguments{
\item{data}{dataframe containing following variables}

\item{replication}{replication}

\item{line}{line}

\item{tester}{tester}

\item{traits}{multiple traits of interest}

\item{block}{block (for alpha lattice design only)}
}
\value{
\item{\code{Mean}}{Table of means.}\item{\code{ANOVA}}{ANOVA with all the factors.}\item{\code{GCA.Line}}{GCA effects of lines.}\item{\code{GCA.Tester}}{GCA effects of testers.}
\item{\code{SCA}}{SCA effects of crosses.}\item{\code{CV}}{Coefficent of Variation.}\item{\code{Genetic.Variance.Covariance}}{Genetic component Variance and covariance.}
\item{\code{Std.Error}}{Standard error for combining ability effects.}\item{\code{C.D.}}{Critical Difference at 5 pecent for combining ability effects.}\item{\code{Add.Dom.Var}}{Additive and Dominance component of Variance.}
\item{\code{Contribution.of.Line.Tester}}{Contribution of Lines, Testers and Line x Tester towards total variation.}
}
\description{
Analysis of Line x Tester data for multiple traits containing only Crosses laid out in RCBD or Alpha Lattice design.
}
\details{
Analyzing the line by tester data of multiple trais only using the data from crosses which are evaluated in RCBD and Alpha lattice design. All the factors are considered as fixed.
}
\note{
The block variable is inserted at the last if the experimental design is Alpha Lattice. For RCBD no need to have block factor.
}
\examples{
\dontrun{#Line Tester analysis data with only crosses in RCBD
library(gpbStat)
data(rcbdltcmt)
result1 = ltcmt(rcbdltcmt, replication, line, tester, rcbdltcmt[,4:5])
result1

#Line Tester analysis data with only crosses in Alpha Lattice
library(gpbStat)
data(alphaltcmt)
result2 = ltcmt(alphaltcmt, replication, line, tester, alphaltcmt[,5:7], block)
result2
}
}
\references{
Kempthorne, O. (1957), Introduction to Genetic Statistics. John Wiley and Sons, New York.
             , 468-472.
Singh, R. K. and Chaudhary, B. D. (1977). Biometrical Methods in Quantitative Genetic Analysis. Kalyani Publishers, New Delhi.
}
\seealso{
\code{\link[gpbStat]{ltcchk}}
}
\author{
Nandan Patil \email{tryanother609@gmail.com}
}
