% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm2.R
\name{dm2}
\alias{dm2}
\title{Analysis of Diallel Method 2 data containing only Crosses laid out in RCBD or Alpha Lattice design.}
\usage{
dm2(data, rep, parent1, parent2, var, block)
}
\arguments{
\item{data}{dataframe containing following variables}

\item{rep}{replication}

\item{parent1}{parent 1}

\item{parent2}{parent 2}

\item{var}{trait of interest}

\item{block}{block (for alpha lattice only)}
}
\value{
\item{\code{Means}}{Two way mean table.}\item{\code{ANOVA}}{ANOVA for the given variable.}\item{\code{Coefficient of Variation}}{Coefficient of Variation of the variable.}\item{\code{Diallel ANOVA}}{Diallel ANVOA for the given trait.}
\item{\code{Genetic Variance}}{GCA & SCA varaince.}\item{\code{Combining ability effects}}{Two way table containing Combining
ability effects of parents and crosses}\item{\code{Standard Error}}{Standard Errror for comining ability effects.}\item{\code{Critical Difference}}{Critical Difference at 5 pecent for combining ability effects.}
}
\description{
Analysis of Diallel Method 2 data containing only Crosses laid out in RCBD or Alpha Lattice design.
}
\details{
Analyzing the Diallel Method 2 data containing only crosses which are evaluated in RCBD & Alpha lattice design. All the factors are considered as fixed.
}
\note{
The blocks are mentioned at end of the function if the experimental design is Alpha Lattice. For RCBD no need mention the blocks.
}
\examples{
\dontrun{#Diallel Method 2 analysis containing only crosses in RCBD.
library(gpbStat)
data(dm2rcbd)
result1 =  dm2(dm2rcbd, rep, parent1, parent2, DTP)
result1

#Diallel Method 2 analysis containing only crosses in Alpha Lattice
library(gpbStat)
data(dm2alpha)
result2 =  dm2(dm2alpha, replication, parent1, parent2, TW, block)
result2

# Save results to csv file
lapply(result2, function(x) write.table(data.frame(x), 'result2.csv'  , append= T, sep=','))
}
}
\references{
Griffing, B. (1956) Concept of General and Specific Combining Ability in relation to Diallel Crossing Systems. Australian Journal of Biological Sciences, 9(4), 463-493.

Dabholkar, A. R. (1999). Elements of Bio Metrical Genetics. Concept Publishing Company, New Delhi.

Singh, R. K. and Chaudhary, B. D. (1977). Biometrical Methods in Quantitative Genetic Analysis. Kalyani Publishers, New Delhi.
}
\seealso{
\code{\link[gpbStat]{ltcchk}, \link[gpbStat]{ltc}}
}
\author{
Nandan Patil \email{tryanother609@gmail.com}
}
