% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPModel.R
\name{fit.GPModel}
\alias{fit.GPModel}
\title{Fits a \code{GPModel}}
\usage{
\method{fit}{GPModel}(gp_model, y, X = NULL, params = list(),
  fixed_effects = NULL)
}
\arguments{
\item{gp_model}{a \code{GPModel}}

\item{y}{A \code{vector} with response variable data}

\item{X}{A \code{matrix} with covariate data for fixed effects ( = linear regression term)}

\item{params}{A \code{list} with parameters for the model fitting / optimization
 \itemize{
    \item{optimizer_cov}{ Optimizer used for estimating covariance parameters. 
    Options: "gradient_descent" or "fisher_scoring". Default="fisher_scoring" for Gaussian data
    and "gradient_descent" for other likelihoods.}
    \item{optimizer_coef}{ Optimizer used for estimating linear regression coefficients, if there are any 
    (for the GPBoost algorithm there are usually none). 
    Options: "gradient_descent" or "wls". Gradient descent steps are done simultaneously 
    with gradient descent steps for the covariance paramters. 
    "wls" refers to doing coordinate descent for the regression coefficients using weighted least squares.
    Default="wls" for Gaussian data and "gradient_descent" for other likelihoods.}
    \item{maxit}{ Maximal number of iterations for optimization algorithm. Default=1000.}
    \item{delta_rel_conv}{ Convergence criterion: stop optimization if relative change 
    in parameters is below this value. Default=1E-6.}
    \item{init_coef}{ Initial values for the regression coefficients (if there are any, can be NULL).
    Default=NULL.}
    \item{init_cov_pars}{ Initial values for covariance parameters of Gaussian process and 
    random effects (can be NULL). Default=NULL.}
    \item{lr_coef}{ Learning rate for fixed effect regression coefficients if gradient descent is used.
    Default=0.1.}
    \item{lr_cov}{ Learning rate for covariance parameters. If <= 0, internal default values are used.
    Default value = 0.1 for "gradient_descent" and 1. for "fisher_scoring"}
    \item{use_nesterov_acc}{ If TRUE Nesterov acceleration is used.
    This is used only for gradient descent. Default=TRUE}
    \item{acc_rate_coef}{ Acceleration rate for regression coefficients (if there are any) 
    for Nesterov acceleration. Default=0.5.}
    \item{acc_rate_cov}{ Acceleration rate for covariance parameters for Nesterov acceleration.
    Default=0.5.}
    \item{momentum_offset}{ Number of iterations for which no mometum is applied in the beginning.
    Default=2.}
    \item{trace}{ If TRUE, the value of the gradient is printed for some iterations.
    Useful for finding good learning rates. Default=FALSE.}
    \item{convergence_criterion}{ The convergence criterion used for terminating the optimization algorithm.
    Options: "relative_change_in_log_likelihood" (default) or "relative_change_in_parameters".}
    \item{std_dev}{ If TRUE, (asymptotic) standard deviations are calculated for the covariance parameters}
}}

\item{fixed_effects}{A \code{vector} of optional external fixed effects which are held fixed during training.}
}
\value{
A fitted \code{GPModel}
}
\description{
Estimates the parameters of a \code{GPModel} using maximum likelihood estimation
}
\examples{
# See https://github.com/fabsig/GPBoost/tree/master/R-package for more examples

library(gpboost)
data(GPBoost_data, package = "gpboost")

#--------------------Grouped random effects model: single-level random effect----------------
gp_model <- GPModel(group_data = group_data[,1], likelihood="gaussian")
fit(gp_model, y = y, params = list(std_dev = TRUE))
summary(gp_model)
# Make predictions
pred <- predict(gp_model, group_data_pred = group_data_test[,1], predict_var = TRUE)
pred$mu # Predicted mean
pred$var # Predicted variances
# Also predict covariance matrix
pred <- predict(gp_model, group_data_pred = group_data_test[,1], predict_cov_mat = TRUE)
pred$mu # Predicted mean
pred$cov # Predicted covariance
 
\donttest{
#--------------------Gaussian process model----------------
gp_model <- GPModel(gp_coords = coords, cov_function = "exponential",
                    likelihood="gaussian")
fit(gp_model, y = y, params = list(std_dev = TRUE))
summary(gp_model)
# Make predictions
pred <- predict(gp_model, gp_coords_pred = coords_test, predict_cov_mat = TRUE)
# Predicted (posterior/conditional) mean of GP
pred$mu
# Predicted (posterior/conditional) covariance matrix of GP
pred$cov
}

}
