% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradDescentR.TopLevelFunctions.R
\name{predict.gradDescentRObject}
\alias{predict.gradDescentRObject}
\alias{predict}
\title{The gradDescentR prediction stage}
\usage{
\method{predict}{gradDescentRObject}(object, newdata, ...)
}
\arguments{
\item{object}{an \code{gradDescentRObject}.}

\item{newdata}{a data frame or matrix (\eqn{m \times n}) of data for the prediction process, where \eqn{m} is the number of instances and
\eqn{n} is the number of input variables. It should be noted that the testing data must be expressed in numbers (numerical data).}

\item{...}{the other parameters (not used)}
}
\value{
The predicted values.
}
\description{
This is the main function to obtain a final result as predicted values for all methods in this package.
In order to get predicted values, this function is run using an \code{gradDescentRObject}, which is typically generated using \code{\link{gradDescentR.learn}}.
}
\examples{
##################################
## Predict NewData Using Model Object
## load R Package data
data(gradDescentRData)
## get z-factor data
dataSet <- gradDescentRData$CompressilbilityFactor
## train dataset
modelObject <- gradDescentR.learn(dataSet)
## create new data input
temp <- c(273.1, 353.1, 363.1)
pres <- c(24.675, 24.675, 24.675)
conf <- c(0.8066773, 0.9235751, 0.9325948)
zfac <- data.frame(temp, pres, conf)
## predict
prediction_data <- predict(modelObject, zfac)


##################################
## Predict NewData Using Model Object
## load R Package data
data(gradDescentRData)
## get z-factor data
dataSet <- gradDescentRData$CompressilbilityFactor
## train dataset
modelObject <- gradDescentR.learn(dataSet, featureScaling=TRUE, scalingMethod="VARIANCE",
               learningMethod="SARAHPlus", control=list(), seed=NULL)
## create new data input
temp <- c(273.1, 353.1, 363.1)
pres <- c(24.675, 24.675, 24.675)
conf <- c(0.8066773, 0.9235751, 0.9325948)
zfac <- data.frame(temp, pres, conf)
## predict
prediction_data <- predict(modelObject, zfac)

}
\seealso{
\code{\link{gradDescentR.learn}}
}
