% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_logscales.R
\name{plot_logscale}
\alias{plot_logscale}
\title{Add log transformations to graphs}
\usage{
plot_logscale(
  Plot,
  LogYTrans = "log10",
  LogXTrans,
  LogYBreaks = waiver(),
  LogXBreaks = waiver(),
  LogYLimits = NULL,
  LogXLimits = NULL,
  LogYLabels = waiver(),
  LogXLabels = waiver(),
  ...
)
}
\arguments{
\item{Plot}{a ggplot2 object.}

\item{LogYTrans}{transform Y axis into "log10" (default) or "log2"}

\item{LogXTrans}{transform X axis into "log10" or "log2"}

\item{LogYBreaks}{argument for \code{ggplot2[scale_y_continuous]} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogXBreaks}{argument for \code{ggplot2[scale_x_continuous]} for Y axis breaks on log scales, default is \code{waiver()}, or provide a vector of desired breaks.}

\item{LogYLimits}{a vector of length two specifying the range (minimum and maximum) of the Y axis.}

\item{LogXLimits}{a vector of length two specifying the range (minimum and maximum) of the X axis.}

\item{LogYLabels}{argument for \code{ggplot2[scale_y_continuous]} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{LogXLabels}{argument for \code{ggplot2[scale_x_continuous]} for Y axis labels on log scales, default is \code{waiver()}, or provide a vector of desired labels.}

\item{...}{any other arguments to pass to \code{\link{scale_y_continuous}[ggplot2]} or \code{\link{scale_x_continuous}[ggplot2]}}
}
\value{
This function returns a \code{ggplot2} object of class "gg" and "ggplot".
}
\description{
This function allows "log10" or "log2" transformation of X or Y axes. With "log10" transformation, log10 ticks are also added on the outside.
}
\details{
Arguments allow for axes limits, breaks and labels to passed on.
}
\examples{
#save a ggplot object
P <- ggplot(data_t_pratio, 
aes(Genotype,Cytokine))+
geom_jitter(shape = 21, 
size = 5, width = .2, 
aes(fill = Genotype), 
alpha = .7)
#transform Y axis
plot_logscale(Plot = P)

#or in one go 
plot_logscale(ggplot(data_t_pratio, 
aes(Genotype,Cytokine))+
geom_jitter(shape = 21, 
size = 5, width = .2, 
aes(fill = Genotype), 
alpha = .7))

}
