% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffexp.R
\name{GetSummarizeMatrix}
\alias{GetSummarizeMatrix}
\alias{GetSummarizeMatrix.grandR}
\alias{GetSummarizeMatrix.default}
\title{Create a summarize matrix}
\usage{
GetSummarizeMatrix(x, ...)

\method{GetSummarizeMatrix}{grandR}(x, no4sU = FALSE, columns = NULL, average = TRUE, ...)

\method{GetSummarizeMatrix}{default}(x, subset = NULL, average = TRUE, ...)
}
\arguments{
\item{x}{A grandR object or a named vector (the names indicate the sample names, the value the conditions to be summarized)}

\item{...}{further arguments to be passed to or from other methods.}

\item{no4sU}{Use no4sU columns (TRUE) or not (FALSE)}

\item{columns}{which columns (i.e. samples or cells) to return (see details)}

\item{average}{matrix to compute the average (TRUE) or the sum (FALSE)}

\item{subset}{logical vector of which elements of the vector v to use (or NULL: use all)}
}
\value{
A matrix to be multiplied with a count table
}
\description{
If this matrix is multiplied with a count table (e.g. obtained by \code{\link{GetTable}}),
either the average (average=TRUE) or the sum (average=FALSE) of all columns (samples or cells)
belonging to the same \code{\link{Condition}} is computed.
}
\details{
Columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
The expression is evaluated in an environment having the \code{\link{Coldata}}, i.e. you can use names of \code{\link{Coldata}} as variables to
conveniently build a logical vector (e.g., columns=Condition="x").

The method for grandR object simply calls the general method
}
\examples{
sars <- ReadGRAND(system.file("extdata", "sars.tsv.gz", package = "grandR"),
                  design=c("Condition",Design$dur.4sU,Design$Replicate))

GetSummarizeMatrix(sars)
head(as.matrix(GetTable(sars)) \%*\% GetSummarizeMatrix(sars))   # average by matrix multiplication
head(GetTable(sars,summarize = TRUE))                          # shortcut, does the same

# See the data-matrices-and-analysis-results vignette for more examples!

}
\seealso{
\link{GetTable}
}
\concept{data}
