% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{Transform.no}
\alias{Transform.no}
\alias{Transform.Z}
\alias{Transform.VST}
\alias{Transform.logFC}
\title{Transformations for PlotHeatmap}
\usage{
Transform.no(label = " ")

Transform.Z(label = "z score", center = TRUE, scale = TRUE)

Transform.VST(label = "VST")

Transform.logFC(label = "log2 FC", LFC.fun = NULL, columns = NULL, ...)
}
\arguments{
\item{label}{label that is used for the heatmap legend}

\item{center}{perform centering when computing Z scores (see \link{scale})}

\item{scale}{perform scaling when computing Z scores (see \link{scale})}

\item{LFC.fun}{function to compute log fold changes (default: \link[lfc]{PsiLFC}, other viable option: \link[lfc]{NormLFC})}

\item{columns}{which columns (i.e. samples or cells) to use as reference when computing log fold changes (see details)}

\item{...}{further parameters passed down to LFC.fun}
}
\value{
A function that transforms a matrix.
}
\description{
Functions to perform transformations on the matrix used for \link{PlotHeatmap}.
}
\details{
These functions should be used as transform parameter to \link{PlotHeatmap}. Available data transformations are
\itemize{
 \item{transform=Transform.Z(): compute z scores for each row; you can omit the usual centering or scaling by setting the respective parameters to false; see \link{scale}}
 \item{transform=Transform.VST(): do a variance stabilizing transformation using \link[DESeq2]{vst}}
 \item{transform=Transform.logFC(): compute log2 fold changes to one or several reference columns; see below how to define them; fold changes are computed using the lfc package)}
 \item{transform=Transform.no(): do not transform}
}

The label to be used in the heatmap legend can be changed by specifying the label parameter.

For Transform.logFC, columns can be given as a logical, integer or character vector representing a selection of the columns (samples or cells).
}
\concept{globalplot}
