% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{CreatePdfs}
\alias{CreatePdfs}
\alias{CreatePdfsParameters}
\alias{CreatePdfsComparison}
\alias{CreatePdfsProfiles}
\title{Convencience methods for creating QC pdfs}
\usage{
CreatePdfs(data, labels = NULL, estimators = NULL)

CreatePdfsParameters(data, labels = NULL, estimators = NULL)

CreatePdfsComparison(data, labels = NULL, estimators = NULL)

CreatePdfsProfiles(data, labels = NULL, estimators = NULL)
}
\arguments{
\item{data}{a grandR object}

\item{labels}{which label to consider (see \link{GetDiagnosticParameters}); if NULL, all available estimators are used}

\item{estimators}{which estimator to consider (see \link{GetDiagnosticParameters}); if NULL, all available estimators are used}
}
\description{
These methods are invoked by GRAND3 to generate pdfs.
}
\section{Functions}{
\itemize{
\item \code{CreatePdfs()}: Create all pdfs

\item \code{CreatePdfsParameters()}: Create pdfs visualizing the estimated parameters

\item \code{CreatePdfsComparison()}: Create pdfs comparing the estimated parameters

\item \code{CreatePdfsProfiles()}: Create pdfs visualizing the profile likelihoods

}}
\concept{diagnostics}
