% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gstud_to_genind.R
\name{gstud_to_genind}
\alias{gstud_to_genind}
\title{Convert a file from \pkg{gstudio} or \pkg{popgraph} into a genind object}
\usage{
gstud_to_genind(x, pop_col, ind_col = NULL)
}
\arguments{
\item{x}{An object of class \code{data.frame} with loci columns in
format \code{locus} (defined in package \pkg{gstudio}) with as many rows as
individuals and as many columns in format \code{locus} as there are loci and
additional columns}

\item{pop_col}{A character string indicating the name of the column with
populations' names in \code{x}}

\item{ind_col}{(optional) A character string indicating the name of the
column with individuals' ID in \code{x}}
}
\value{
An object of class \code{genind}.
}
\description{
The function converts a file formatted to use \pkg{gstudio} or
\pkg{popgraph} package into a genind object (\pkg{adegenet} package)
}
\details{
This function uses functions from \pkg{pegas} package.
It can handle genetic data where alleles codings do not have same length,
(99:101, for example).
If the names of the loci include '.' characters, they will
be replaced by '_'.
}
\examples{
data("data_pc_gstud")
x <- data_pc_gstud
pop_col <- "Cluster"
ind_col <- "ID"
data_genind <- gstud_to_genind(x, pop_col, ind_col)
}
\author{
P. Savary
}
