% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_checks.R
\name{check_graph}
\alias{check_graph}
\title{Check input graph}
\usage{
check_graph(
  graph,
  graph_type = c("general", "decomposable", "block", "tree"),
  check_connected = TRUE,
  nVertices = NULL
)
}
\arguments{
\item{graph}{An [\code{igraph::graph}] object.}

\item{graph_type}{\code{"general"}, \code{"decomposable"}, \code{"block"}, \code{"tree"}. The required type of graph.}

\item{check_connected}{Whether to check if the graph is connected.}

\item{nVertices}{The number of vertices required in the graph.}
}
\value{
The given \code{graph}, if necessary converted to undirected.
If the graph is not valid an error is thrown.
}
\description{
Checks that the input graph is a valid graph for an extremal graphical model.
If necessary, converts the graph to an undirected graph.
Removes vertex labels if present.
}
\seealso{
Other Input checks: 
\code{\link{check_Gamma_and_graph}()}
}
\concept{Input checks}
