% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_generate_weights.R
\name{graph_generate_weights}
\alias{graph_generate_weights}
\title{Generate the weighting strategy based on a graphical multiple comparison
procedure}
\usage{
graph_generate_weights(graph)
}
\arguments{
\item{graph}{An initial graph as returned by \code{\link[=graph_create]{graph_create()}}.}
}
\value{
A numeric matrix of all intersection hypotheses and their hypothesis
weights. For a graphical multiple comparison procedure with \eqn{m} hypotheses,
the number of rows is \eqn{2^{m}-1}, each of which corresponds to an intersection
hypothesis. The number of columns is \eqn{2\cdot m}. The first \eqn{m} columns
indicate which individual hypotheses are included in a given intersection
hypothesis and the second half of columns provide hypothesis weights for each
individual hypothesis for a given intersection hypothesis.
}
\description{
A graphical multiple comparison procedure defines a closed test procedure,
which tests each intersection hypothesis and reject an individual hypothesis
if all intersection hypotheses involving it have been rejected. An
intersection hypothesis represents the parameter space where individual null
hypotheses involved are true simultaneously.

The closure based on a graph consists of all updated graphs (corresponding
to intersection hypotheses) after all combinations of hypotheses are deleted.
For a graphical multiple comparison procedure with \eqn{m} hypotheses, there
are \eqn{2^{m}-1} updated graphs (intersection hypotheses), including the
initial graph (the overall intersection hypothesis). The weighting strategy
of this graph consists of hypothesis weights from all \eqn{2^{m}-1} updated
graphs (intersection hypotheses). The algorithm to derive the weighting
strategy is based on Algorithm 1 in Bretz et al. (2011).
}
\section{Performance}{

Generation of intersection hypotheses is closely related to the power set
of a given set of indices. As the number of hypotheses increases, the memory
and time usage can grow quickly (e.g., at a rate of \eqn{O(2^n)}). There are also
multiple ways to implement Algorithm 1 in Bretz et al. (2011). See
\code{vignette("generate-closure")} for more information about generating
intersection hypotheses and comparisons of different approaches to calculate
weighting strategies.
}

\examples{
# A graphical multiple comparison procedure with two primary hypotheses (H1
# and H2) and two secondary hypotheses (H3 and H4)
# See Figure 1 in Bretz et al. (2011).
hypotheses <- c(0.5, 0.5, 0, 0)
transitions <- rbind(
  c(0, 0, 1, 0),
  c(0, 0, 0, 1),
  c(0, 1, 0, 0),
  c(1, 0, 0, 0)
)
g <- graph_create(hypotheses, transitions)

graph_generate_weights(g)
}
\references{
Bretz, F., Posch, M., Glimm, E., Klinglmueller, F., Maurer, W., and
Rohmeyer, K. (2011). Graphical approaches for multiple comparison
procedures using weighted Bonferroni, Simes, or parametric tests.
\emph{Biometrical Journal}, 53(6), 894-913.
}
\seealso{
\code{\link[=graph_test_closure]{graph_test_closure()}} for graphical multiple comparison procedures using
the closed test.
}
