% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_tests.R
\name{graph_test_closure_fast}
\alias{graph_test_closure_fast}
\alias{graph_test_shortcut_fast}
\title{Perform graphical multiple comparison procedures efficiently for power
calculation}
\usage{
graph_test_closure_fast(p, alpha, adjusted_weights, matrix_intersections)

graph_test_shortcut_fast(p, alpha, adjusted_weights)
}
\arguments{
\item{p}{A numeric vector of one-sided p-values (unadjusted, raw), whose
values should be between 0 & 1. The length should match the number of
hypotheses in \code{graph}.}

\item{alpha}{A numeric value of the one-sided overall significance level,
which should be between 0 & 1. The default is 0.025 for one-sided
hypothesis testing. Note that only one-sided tests are supported.}

\item{adjusted_weights}{The adjusted hypothesis weights, which are the
second half of columns from \code{\link[=graph_generate_weights]{graph_generate_weights()}} output, adjusted by
the appropriate test types (Bonferroni, Simes, or parametric).}

\item{matrix_intersections}{A matrix of hypothesis indicators in a weighting
strategy, which are the first half the \code{\link[=graph_generate_weights]{graph_generate_weights()}} output.}
}
\value{
A logical or integer vector indicating whether each hypothesis can
be rejected or not.
}
\description{
These functions performs similarly to \code{\link[=graph_test_closure]{graph_test_closure()}} or
\code{\link[=graph_test_shortcut]{graph_test_shortcut()}} but are optimized for efficiently calculating power.
For example, generating weights and calculating adjusted weights can be done
only once. Vectorization has been applied where possible.
}
\seealso{
\itemize{
\item \code{\link[=graph_test_closure]{graph_test_closure()}} for closed graphical multiple comparison
procedures.
\item \code{\link[=graph_test_shortcut]{graph_test_shortcut()}} for shortcut graphical multiple comparison
procedures.
}
}
\keyword{internal}
