% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate_graph.R
\name{graph_manipulate}
\alias{graph_manipulate}
\alias{reorder_edges}
\title{Manipulate graph}
\usage{
reorder_edges(g, attr, desc = TRUE)
}
\arguments{
\item{g}{igraph object}

\item{attr}{edge attribute name used to sort edges}

\item{desc}{logical. sort in descending (default) or ascending order}
}
\value{
manipulated graphs
}
\description{
functions to manipulate graphs
}
\details{
\code{reorder_edges()} allows to reorder edges according to an attribute so that edges are
drawn in the given order.
}
\examples{
library(igraph)
library(ggraph)

g <- sample_gnp(10,0.5)
E(g)$attr <- 1:ecount(g)
ggraph(g,layout="stress")+
  geom_edge_link(aes(col=attr))+
  geom_node_point()+
  theme_graph()+
  theme(legend.position="none")

gn <- reorder_edges(g,"attr")
ggraph(gn,layout="stress")+
  geom_edge_link(aes(col=attr))+
  geom_node_point()+
  theme_graph()+
  theme(legend.position="none")

}
\author{
David Schoch
}
