% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cgeneric_LKJ.R
\name{cgeneric_LKJ}
\alias{cgeneric_LKJ}
\title{Build an \code{inla.cgeneric} object to implement the
LKG prior for the correlation matrix.}
\usage{
cgeneric_LKJ(n, eta, debug = FALSE, useINLAprecomp = TRUE, libpath = NULL)
}
\arguments{
\item{n}{integer to define the size of the matrix}

\item{eta}{numeric greater than 1, the parameter}

\item{debug}{integer, default is zero, indicating the verbose level.
Will be used as logical by INLA.}

\item{useINLAprecomp}{logical, default is TRUE, indicating if it is to
be used the shared object pre-compiled by INLA.
This is not considered if 'libpath' is provided.}

\item{libpath}{string, default is NULL, with the path to the shared object.}
}
\value{
a \code{inla.cgeneric}, \code{\link[=cgeneric]{cgeneric()}} object.
}
\description{
Build an \code{inla.cgeneric} object to implement the
LKG prior for the correlation matrix.
}
\details{
The parametrization uses the
hypershere decomposition, as proposed in
Rapisarda, Brigo and Mercurio (2007).
consider \eqn{\theta[k] \in [0, \infty], k=1,...,m=n(n-1)/2}
from \eqn{\theta[k] \in [0, \infty], k=1,...,m=n(n-1)/2}
compute \eqn{x[k] = pi/(1+exp(-theta[k]))}
organize it as a lower triangle of a \eqn{n \times n} matrix
\deqn{         | cos(x[i,j])                           ,      j=1}
\deqn{B[i,j] = | cos(x[i,j])prod_{k=1}^{j-1}sin(x[i,k]),  2 <= j <= i-1}
\deqn{         | prod_{k=1}^{j-1}sin(x[i,k])           ,      j=i}
\deqn{         | 0                                     , j+1 <= j <= n }
Result
\deqn{\gamma[i,j] = -log(sin(x[i,j]))}
\deqn{KLD(R) = \sqrt(2\sum_{i=2}^n\sum_{j=1}^{i-1} \gamma[i,j]}
}
\references{
Rapisarda, Brigo and Mercurio (2007).
Parameterizing correlations: a geometric interpretation.
IMA Journal of Management Mathematics (2007) 18, 55-73.
<doi 10.1093/imaman/dpl010>
}
